/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.cdp.entities.Protocol;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserRunner.class);
    private final String executablePath;
    private final List<String> processArguments;
    private final String tempDirectory;
    private Protocol protocol;
    private final Product product;
    private Process process;
    private Connection connection;
    private volatile boolean closed;
    private static final List<BrowserRunner> runners = Collections.synchronizedList(new ArrayList());
    private static boolean isRegisterShutdownHook = false;
    private final String customizedUserDataDir;
    private String pid;

    public BrowserRunner(String executablePath, List<String> processArguments, String tempDirectory, Product product, Protocol protocol, String customizedUserDataDir) {
        this.executablePath = executablePath;
        this.processArguments = processArguments;
        this.tempDirectory = tempDirectory;
        this.product = product;
        this.protocol = protocol;
        this.customizedUserDataDir = customizedUserDataDir;
        if (Product.Firefox.equals((Object)this.product) && Objects.isNull((Object)this.protocol)) {
            this.protocol = Protocol.WebDriverBiDi;
        }
        this.closed = true;
    }

    public void start() throws IOException {
        if (this.process != null) {
            throw new JvppeteerException("This process has previously been started.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executablePath);
        arguments.addAll(this.processArguments);
        ProcessBuilder processBuilder = new ProcessBuilder(arguments).redirectErrorStream(true);
        this.process = processBuilder.start();
        this.closed = false;
        this.registerHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHook() {
        runners.add(this);
        if (isRegisterShutdownHook) {
            return;
        }
        Class<BrowserRunner> clazz = BrowserRunner.class;
        synchronized (BrowserRunner.class) {
            if (!isRegisterShutdownHook) {
                RuntimeShutdownHookRegistry hook = new RuntimeShutdownHookRegistry();
                hook.register(new Thread(this::closeAllBrowser));
                isRegisterShutdownHook = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.closed) {
            return;
        }
        try {
            Process exec;
            String command;
            if ("-1".equals(this.pid) || StringUtil.isEmpty(this.pid)) {
                this.destroyProcess(this.process);
                return;
            }
            if (Helper.isLinux() || Helper.isMac()) {
                command = "kill -9 " + this.pid;
                exec = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            } else {
                command = "cmd.exe /c taskkill /pid " + this.pid + " /F /T ";
                exec = Runtime.getRuntime().exec(command);
            }
            try {
                if (Objects.nonNull(exec)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("kill chrome process by pid,command:  {}", (Object)command);
                    }
                    exec.waitFor(30000L, TimeUnit.MILLISECONDS);
                }
                this.destroyProcess(this.process);
            }
            finally {
                this.destroyProcess(exec);
            }
        }
        catch (Exception e) {
            LOGGER.error("kill chrome process error ", (Throwable)e);
        }
        finally {
            try {
                this.cleanUserDataDir();
            }
            catch (IOException iOException) {}
        }
    }

    public void destroyProcess(Process process) {
        if (Objects.isNull(process)) {
            return;
        }
        process.destroy();
        try {
            process.waitFor(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("operation interrupt", (Throwable)e);
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public void closeAllBrowser() {
        for (BrowserRunner browserRunner : runners) {
            browserRunner.closeBrowser();
        }
    }

    public void closeBrowser() {
        if (this.closed) {
            return;
        }
        if (!Objects.equals((Object)this.product, (Object)Product.Firefox) && Objects.nonNull(this.connection) && !this.connection.closed()) {
            this.connection.send("Browser.close", null, null, false);
        }
        this.destroy();
        this.closed = true;
    }

    private void cleanUserDataDir() throws IOException {
        if (this.closed) {
            return;
        }
        if (StringUtil.isNotEmpty(this.tempDirectory)) {
            try {
                FileUtil.removeFolder(this.tempDirectory);
                if (Paths.get(this.tempDirectory, new String[0]).toFile().exists()) {
                    FileUtil.removeFolderOnExit(this.tempDirectory);
                }
            }
            catch (Exception exception) {}
        } else if (Objects.equals((Object)this.product, (Object)Product.Firefox) && Objects.equals((Object)this.protocol, (Object)Protocol.WebDriverBiDi)) {
            String prefsPath = Helper.join(this.customizedUserDataDir, "prefs.js");
            String userPath = Helper.join(this.customizedUserDataDir, "user.js");
            Path prefsSource = Paths.get(prefsPath + ".bak", new String[0]);
            Files.copy(prefsSource, Paths.get(prefsPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Path userSource = Paths.get(userPath + ".bak", new String[0]);
            Files.copy(userSource, Paths.get(userPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(prefsSource);
            Files.deleteIfExists(userSource);
        }
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public static class RuntimeShutdownHookRegistry
    implements ShutdownHookRegistry {
    }

    public static interface ShutdownHookRegistry {
        default public void register(Thread thread) {
            Runtime.getRuntime().addShutdownHook(thread);
        }

        default public void remove(Thread thread) {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }
}

