/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Keyboard;
import com.ruiyun.jvppeteer.cdp.entities.KeyDefinition;
import com.ruiyun.jvppeteer.cdp.entities.KeyDescription;
import com.ruiyun.jvppeteer.cdp.entities.KeyDownOptions;
import com.ruiyun.jvppeteer.cdp.entities.KeyPressOptions;
import com.ruiyun.jvppeteer.cdp.entities.KeyboardTypeOptions;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CdpKeyboard
extends Keyboard {
    private volatile CDPSession client;
    private int modifiers;
    private final Set<String> pressedKeys = new HashSet<String>();

    public CdpKeyboard(CDPSession client) {
        this.client = client;
    }

    @Override
    public void down(String key, KeyDownOptions options) {
        KeyDescription description = this.keyDescriptionForString(key);
        boolean autoRepeat = this.pressedKeys.contains(description.getCode());
        this.pressedKeys.add(description.getCode());
        this.modifiers |= this.modifierBit(description.getKey());
        if (StringUtil.isEmpty(options.getText())) {
            options.setText(description.getText());
        }
        Map<String, Object> params = ParamsFactory.create();
        if (StringUtil.isNotEmpty(options.getText())) {
            params.put("type", "keyDown");
        } else {
            params.put("type", "rawKeyDown");
        }
        params.put("modifiers", this.modifiers);
        params.put("windowsVirtualKeyCode", description.getKeyCode());
        params.put("code", description.getCode());
        params.put("key", description.getKey());
        params.put("text", options.getText());
        params.put("unmodifiedText", options.getText());
        params.put("autoRepeat", autoRepeat);
        params.put("location", description.getLocation());
        params.put("isKeypad", description.getLocation() == 3);
        params.put("commands", options.getCommands());
        this.client.send("Input.dispatchKeyEvent", params);
    }

    public void down(String key) {
        this.down(key, new KeyDownOptions());
    }

    @Override
    public void up(String key) {
        KeyDescription description = this.keyDescriptionForString(key);
        this.modifiers &= ~this.modifierBit(description.getKey());
        this.pressedKeys.remove(description.getCode());
        Map<String, Object> params = ParamsFactory.create();
        params.put("type", "keyUp");
        params.put("modifiers", this.modifiers);
        params.put("key", description.getKey());
        params.put("windowsVirtualKeyCode", description.getKeyCode());
        params.put("code", description.getCode());
        params.put("location", description.getLocation());
        this.client.send("Input.dispatchKeyEvent", params);
    }

    @Override
    public void sendCharacter(String cha) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("text", cha);
        this.client.send("Input.insertText", params);
    }

    private boolean charIsKey(String c) {
        return keyDefinitions.containsKey(c);
    }

    @Override
    public void type(String text, KeyboardTypeOptions options) {
        for (int i = 0; i < text.length(); ++i) {
            String c = String.valueOf(text.charAt(i));
            if (this.charIsKey(c)) {
                KeyPressOptions pressOptions = new KeyPressOptions();
                pressOptions.setDelay(options.getDelay());
                this.press(c, pressOptions);
                continue;
            }
            if (options.getDelay() > 0L) {
                Helper.justWait(options.getDelay());
            }
            this.sendCharacter(c);
        }
    }

    @Override
    public void press(String key, KeyPressOptions options) {
        KeyDownOptions downOptions = new KeyDownOptions();
        downOptions.setText(options.getText());
        downOptions.setCommands(options.getCommands());
        this.down(key, downOptions);
        if (options.getDelay() > 0L) {
            Helper.justWait(options.getDelay());
        }
        this.up(key);
    }

    private int modifierBit(String key) {
        if ("Alt".equals(key)) {
            return 1;
        }
        if ("Control".equals(key)) {
            return 2;
        }
        if ("Meta".equals(key)) {
            return 4;
        }
        if ("Shift".equals(key)) {
            return 8;
        }
        return 0;
    }

    private KeyDescription keyDescriptionForString(String keyString) {
        int shift = this.modifiers & 8;
        KeyDescription description = new KeyDescription("", 0, "", "", 0);
        KeyDefinition definition = (KeyDefinition)keyDefinitions.get(keyString);
        Objects.requireNonNull(definition, "Unknown key: " + keyString);
        if (StringUtil.isNotEmpty(definition.getKey())) {
            description.setKey(definition.getKey());
        }
        if (shift != 0 && StringUtil.isNotEmpty(definition.getShiftKey())) {
            description.setKey(definition.getShiftKey());
        }
        if (definition.getKeyCode() != 0) {
            description.setKeyCode(definition.getKeyCode());
        }
        if (shift != 0 && definition.getShiftKeyCode() != 0) {
            description.setKeyCode(definition.getShiftKeyCode());
        }
        if (StringUtil.isNotEmpty(definition.getCode())) {
            description.setCode(definition.getCode());
        }
        if (definition.getLocation() != 0) {
            description.setLocation(definition.getLocation());
        }
        if (description.getKey().length() == 1) {
            description.setText(description.getKey());
        }
        if (StringUtil.isNotEmpty(definition.getText())) {
            description.setText(definition.getText());
        }
        if (shift != 0 && StringUtil.isNotEmpty(definition.getShiftText())) {
            description.setText(definition.getShiftText());
        }
        if ((this.modifiers & 0xFFFFFFF7) != 0) {
            description.setText("");
        }
        return description;
    }

    int getModifiers() {
        return this.modifiers;
    }

    void updateClient(CDPSession client) {
        this.client = client;
    }
}

