/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Response;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.core.WebWorker;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.api.events.PageEvents;
import com.ruiyun.jvppeteer.cdp.core.Accessibility;
import com.ruiyun.jvppeteer.cdp.core.CdpDialog;
import com.ruiyun.jvppeteer.cdp.core.CdpFrame;
import com.ruiyun.jvppeteer.cdp.core.CdpKeyboard;
import com.ruiyun.jvppeteer.cdp.core.CdpMouse;
import com.ruiyun.jvppeteer.cdp.core.CdpTarget;
import com.ruiyun.jvppeteer.cdp.core.CdpTouchscreen;
import com.ruiyun.jvppeteer.cdp.core.CdpWebWorker;
import com.ruiyun.jvppeteer.cdp.core.Coverage;
import com.ruiyun.jvppeteer.cdp.core.EmulationManager;
import com.ruiyun.jvppeteer.cdp.core.FileChooser;
import com.ruiyun.jvppeteer.cdp.core.FrameManager;
import com.ruiyun.jvppeteer.cdp.core.IsolatedWorld;
import com.ruiyun.jvppeteer.cdp.core.NetworkManager;
import com.ruiyun.jvppeteer.cdp.core.TargetManager;
import com.ruiyun.jvppeteer.cdp.core.Tracing;
import com.ruiyun.jvppeteer.cdp.entities.Binding;
import com.ruiyun.jvppeteer.cdp.entities.BindingPayload;
import com.ruiyun.jvppeteer.cdp.entities.CallFrame;
import com.ruiyun.jvppeteer.cdp.entities.ConsoleMessage;
import com.ruiyun.jvppeteer.cdp.entities.ConsoleMessageLocation;
import com.ruiyun.jvppeteer.cdp.entities.ConsoleMessageType;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookieParam;
import com.ruiyun.jvppeteer.cdp.entities.Credentials;
import com.ruiyun.jvppeteer.cdp.entities.DeleteCookiesRequest;
import com.ruiyun.jvppeteer.cdp.entities.EvaluateType;
import com.ruiyun.jvppeteer.cdp.entities.GeolocationOptions;
import com.ruiyun.jvppeteer.cdp.entities.GetMetricsResponse;
import com.ruiyun.jvppeteer.cdp.entities.GetNavigationHistoryResponse;
import com.ruiyun.jvppeteer.cdp.entities.IdleOverridesState;
import com.ruiyun.jvppeteer.cdp.entities.ImageType;
import com.ruiyun.jvppeteer.cdp.entities.LengthUnit;
import com.ruiyun.jvppeteer.cdp.entities.MediaFeature;
import com.ruiyun.jvppeteer.cdp.entities.Metric;
import com.ruiyun.jvppeteer.cdp.entities.Metrics;
import com.ruiyun.jvppeteer.cdp.entities.NavigationEntry;
import com.ruiyun.jvppeteer.cdp.entities.NetworkConditions;
import com.ruiyun.jvppeteer.cdp.entities.NewDocumentScriptEvaluation;
import com.ruiyun.jvppeteer.cdp.entities.PDFMargin;
import com.ruiyun.jvppeteer.cdp.entities.PDFOptions;
import com.ruiyun.jvppeteer.cdp.entities.PageMetrics;
import com.ruiyun.jvppeteer.cdp.entities.PaperFormats;
import com.ruiyun.jvppeteer.cdp.entities.RemoteObject;
import com.ruiyun.jvppeteer.cdp.entities.ScreenshotClip;
import com.ruiyun.jvppeteer.cdp.entities.ScreenshotOptions;
import com.ruiyun.jvppeteer.cdp.entities.StackTrace;
import com.ruiyun.jvppeteer.cdp.entities.UserAgentMetadata;
import com.ruiyun.jvppeteer.cdp.entities.Viewport;
import com.ruiyun.jvppeteer.cdp.entities.VisionDeficiency;
import com.ruiyun.jvppeteer.cdp.entities.WaitForOptions;
import com.ruiyun.jvppeteer.cdp.events.BindingCalledEvent;
import com.ruiyun.jvppeteer.cdp.events.ConsoleAPICalledEvent;
import com.ruiyun.jvppeteer.cdp.events.EntryAddedEvent;
import com.ruiyun.jvppeteer.cdp.events.ExceptionThrownEvent;
import com.ruiyun.jvppeteer.cdp.events.FileChooserOpenedEvent;
import com.ruiyun.jvppeteer.cdp.events.JavascriptDialogOpeningEvent;
import com.ruiyun.jvppeteer.cdp.events.MetricsEvent;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.BindingFunction;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.MediaType;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.exception.TargetCloseException;
import com.ruiyun.jvppeteer.transport.CdpCDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class CdpPage
extends Page {
    private volatile boolean closed = false;
    private final TargetManager targetManager;
    private volatile CDPSession primaryTargetClient;
    private CdpTarget primaryTarget;
    private final CDPSession tabTargetClient;
    private final CdpTarget tabTarget;
    private final CdpKeyboard keyboard;
    private final CdpMouse mouse;
    private final CdpTouchscreen touchscreen;
    private FrameManager frameManager;
    private final EmulationManager emulationManager;
    private final Tracing tracing;
    private final Map<String, Binding> bindings = new HashMap<String, Binding>();
    private final Map<String, String> exposedFunctions = new HashMap<String, String>();
    private final Coverage coverage;
    private Viewport viewport;
    private final Map<String, CdpWebWorker> workers = new HashMap<String, CdpWebWorker>();
    private final Set<AwaitableResult<FileChooser>> fileChooserResults = new HashSet<AwaitableResult<FileChooser>>();
    private final AwaitableResult<TargetCloseException> sessionCloseResult = AwaitableResult.create();
    private boolean serviceWorkerBypassed = false;
    private boolean userDragInterceptionEnabled = false;
    private final Consumer<CdpCDPSession> onAttachedToTarget = session -> {
        this.frameManager.onAttachedToTarget(session.getTarget());
        if ("worker".equals(session.getTarget().getTargetInfo().getType())) {
            CdpWebWorker webWorker = new CdpWebWorker((CDPSession)session, session.getTarget().url(), session.getTarget().getTargetId(), session.getTarget().type(), this::addConsoleMessage, this::handleException, this.frameManager.networkManager());
            this.workers.put(session.id(), webWorker);
            this.emit(PageEvents.WorkerCreated, webWorker);
        }
        session.on(ConnectionEvents.CDPSession_Ready, this.onAttachedToTarget);
    };

    public CdpPage(CDPSession client, CdpTarget target) {
        this.primaryTargetClient = client;
        this.tabTargetClient = client.parentSession();
        Objects.requireNonNull(this.tabTargetClient, "Tab target session is not defined.");
        this.tabTarget = ((CdpCDPSession)this.tabTargetClient).getTarget();
        Objects.requireNonNull(this.tabTarget, "Tab target is not defined.");
        this.primaryTarget = target;
        this.targetManager = target.targetManager();
        this.keyboard = new CdpKeyboard(client);
        this.mouse = new CdpMouse(client, this.keyboard);
        this.touchscreen = new CdpTouchscreen(client, this.keyboard);
        this.frameManager = new FrameManager(client, this, this._timeoutSettings);
        this.emulationManager = new EmulationManager(client);
        this.tracing = new Tracing(client);
        this.coverage = new Coverage(client);
        this.viewport = null;
        Map<FrameManager.FrameManagerEvent, Consumer> frameManagerHandlers = Collections.unmodifiableMap(new HashMap<FrameManager.FrameManagerEvent, Consumer<?>>(){
            {
                this.put(FrameManager.FrameManagerEvent.FrameAttached, frame -> CdpPage.this.emit(PageEvents.FrameAttached, frame));
                this.put(FrameManager.FrameManagerEvent.FrameDetached, frame -> CdpPage.this.emit(PageEvents.FrameDetached, frame));
                this.put(FrameManager.FrameManagerEvent.FrameNavigated, frame -> CdpPage.this.emit(PageEvents.FrameNavigated, frame));
                this.put(FrameManager.FrameManagerEvent.ConsoleApiCalled, arg -> CdpPage.this.onConsoleAPI((IsolatedWorld)arg[0], (ConsoleAPICalledEvent)arg[1]));
                this.put(FrameManager.FrameManagerEvent.BindingCalled, arg -> CdpPage.this.onBindingCalled((IsolatedWorld)arg.get(0), (BindingCalledEvent)arg.get(1)));
            }
        });
        frameManagerHandlers.forEach(this.frameManager::on);
        Map<NetworkManager.NetworkManagerEvent, Consumer> networkManagerHandlers = Collections.unmodifiableMap(new HashMap<NetworkManager.NetworkManagerEvent, Consumer<?>>(){
            {
                this.put(NetworkManager.NetworkManagerEvent.Request, request -> CdpPage.this.emit(PageEvents.Request, request));
                this.put(NetworkManager.NetworkManagerEvent.RequestServedFromCache, request -> CdpPage.this.emit(PageEvents.RequestServedFromCache, request));
                this.put(NetworkManager.NetworkManagerEvent.Response, response -> CdpPage.this.emit(PageEvents.Response, response));
                this.put(NetworkManager.NetworkManagerEvent.RequestFailed, request -> CdpPage.this.emit(PageEvents.RequestFailed, request));
                this.put(NetworkManager.NetworkManagerEvent.RequestFinished, request -> CdpPage.this.emit(PageEvents.RequestFinished, request));
            }
        });
        networkManagerHandlers.forEach((key, value) -> this.frameManager.networkManager().on(key, (Consumer<?>)value));
        this.tabTargetClient.on(ConnectionEvents.CDPSession_Swapped, this::onActivation);
        this.tabTargetClient.on(ConnectionEvents.CDPSession_Ready, this::onSecondaryTarget);
        Consumer<CdpTarget> onDetachedFromTarget = cdpTarget -> {
            if (cdpTarget.session() == null) {
                return;
            }
            String sessionId = cdpTarget.session().id();
            CdpWebWorker webWorker = this.workers.get(sessionId);
            if (webWorker == null) {
                return;
            }
            this.workers.remove(sessionId);
            this.emit(PageEvents.WorkerDestroyed, webWorker);
        };
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetGone, onDetachedFromTarget);
        this.tabTarget.setOnCloseRunner(() -> {
            this.targetManager.off(TargetManager.TargetManagerEvent.TargetGone, onDetachedFromTarget);
            this.emit(PageEvents.Close, true);
            this.closed = true;
        });
        this.setupPrimaryTargetListeners();
        this.attachExistingTargets();
    }

    private void attachExistingTargets() {
        List<CdpTarget> childTargets = this.targetManager.getChildTargets(this.primaryTarget);
        ArrayList<CdpTarget> queue = new ArrayList<CdpTarget>(childTargets);
        int idx = 0;
        while (idx < queue.size()) {
            CdpTarget next = (CdpTarget)queue.get(idx);
            ++idx;
            CdpCDPSession session = (CdpCDPSession)next.session();
            if (Objects.nonNull(session)) {
                this.onAttachedToTarget.accept(session);
            }
            queue.addAll(this.targetManager.getChildTargets(next));
        }
    }

    private void onActivation(CDPSession newSession) {
        this.primaryTargetClient = newSession;
        this.primaryTarget = ((CdpCDPSession)this.primaryTargetClient).getTarget();
        Objects.requireNonNull(this.primaryTarget, "Missing target on swap");
        this.keyboard.updateClient(newSession);
        this.mouse.updateClient(newSession);
        this.touchscreen.updateClient(newSession);
        this.emulationManager.updateClient(newSession);
        this.tracing.updateClient(newSession);
        this.coverage.updateClient(newSession);
        this.frameManager.swapFrameTree(newSession);
        this.setupPrimaryTargetListeners();
    }

    private void setupPrimaryTargetListeners() {
        Map<ConnectionEvents, Consumer> sessionHandlers = Collections.unmodifiableMap(new HashMap<ConnectionEvents, Consumer<?>>(){
            {
                this.put(ConnectionEvents.CDPSession_Ready, session -> CdpPage.this.onAttachedToTarget.accept((CdpCDPSession)session));
                this.put(ConnectionEvents.CDPSession_Disconnected, ignore -> CdpPage.this.sessionCloseResult.onSuccess(new TargetCloseException("Target closed")));
                this.put(ConnectionEvents.Page_domContentEventFired, ignore -> CdpPage.this.emit(PageEvents.Domcontentloaded, true));
                this.put(ConnectionEvents.Page_loadEventFired, ignore -> CdpPage.this.emit(PageEvents.Load, true));
                this.put(ConnectionEvents.Page_javascriptDialogOpening, x$0 -> CdpPage.this.onDialog(x$0));
                this.put(ConnectionEvents.Runtime_exceptionThrown, x$0 -> CdpPage.this.handleException(x$0));
                this.put(ConnectionEvents.Inspector_targetCrashed, ignore -> CdpPage.this.onTargetCrashed());
                this.put(ConnectionEvents.Performance_metrics, x$0 -> CdpPage.this.emitMetrics(x$0));
                this.put(ConnectionEvents.Log_entryAdded, x$0 -> CdpPage.this.onLogEntryAdded(x$0));
                this.put(ConnectionEvents.Page_fileChooserOpened, x$0 -> CdpPage.this.onFileChooser(x$0));
            }
        });
        sessionHandlers.forEach((eventName, handler) -> this.primaryTargetClient.on(eventName, (Consumer<?>)handler));
    }

    private void onSecondaryTarget(CdpCDPSession session) {
        if (!"prerender".equals(session.getTarget().subtype())) {
            return;
        }
        try {
            this.frameManager.registerSpeculativeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("frameManager registerSpeculativeSession error: ", (Throwable)e);
        }
        try {
            this.emulationManager.registerSpeculativeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("emulationManager registerSpeculativeSession error: ", (Throwable)e);
        }
    }

    private void initialize() {
        try {
            this.frameManager.initialize(this.primaryTargetClient, null);
            HashMap params = new HashMap();
            this.primaryTargetClient.send("Performance.enable", params);
            this.primaryTargetClient.send("Log.enable", params);
        }
        catch (Exception e) {
            if (e instanceof ProtocolException) {
                LOGGER.error("initialize error: ", (Throwable)e);
            }
            throw e;
        }
    }

    private void onFileChooser(FileChooserOpenedEvent event) {
        if (this.fileChooserResults.isEmpty()) {
            return;
        }
        CdpFrame frame = this.frameManager.frame(event.getFrameId());
        Objects.requireNonNull(frame, "This should never happen.");
        IsolatedWorld mainWorld = frame.worlds().get("mainWorld");
        ElementHandle handle = null;
        try {
            handle = mainWorld.adoptBackendNode(event.getBackendNodeId()).asElement();
        }
        catch (JsonProcessingException e) {
            Helper.throwError(e);
        }
        FileChooser fileChooser = new FileChooser(handle, !Objects.equals(event.getMode(), "selectSingle"));
        for (AwaitableResult<FileChooser> subject : this.fileChooserResults) {
            subject.onSuccess(fileChooser);
        }
        this.fileChooserResults.clear();
    }

    public CDPSession client() {
        return this.primaryTargetClient;
    }

    @Override
    public boolean isServiceWorkerBypassed() {
        return this.serviceWorkerBypassed;
    }

    @Override
    @Deprecated
    public boolean isDragInterceptionEnabled() {
        return this.userDragInterceptionEnabled;
    }

    @Override
    public boolean isJavaScriptEnabled() {
        return this.emulationManager.javascriptEnabled();
    }

    @Override
    public AwaitableResult<FileChooser> fileChooserWaitFor() {
        AwaitableResult<FileChooser> result = AwaitableResult.create();
        boolean needsEnable = this.fileChooserResults.isEmpty();
        this.fileChooserResults.add(result);
        if (needsEnable) {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("enabled", true);
            this.primaryTargetClient.send("Page.setInterceptFileChooserDialog", params);
        }
        return result;
    }

    @Override
    public void setGeolocation(GeolocationOptions options) {
        super.setGeolocation(options);
        this.emulationManager.setGeolocation(options);
    }

    @Override
    public Target target() {
        return this.primaryTarget;
    }

    @Override
    public Browser browser() {
        return this.primaryTarget.browser();
    }

    @Override
    public BrowserContext browserContext() {
        return this.primaryTarget.browserContext();
    }

    private void onTargetCrashed() {
        this.emit(PageEvents.Error, new JvppeteerException("Page crashed!"));
    }

    private void onLogEntryAdded(EntryAddedEvent event) {
        if (ValidateUtil.isNotEmpty(event.getEntry().getArgs())) {
            event.getEntry().getArgs().forEach(arg -> Helper.releaseObject(this.primaryTargetClient, arg));
        }
        if (!"worker".equals(event.getEntry().getSource())) {
            ArrayList<ConsoleMessageLocation> locations = new ArrayList<ConsoleMessageLocation>();
            locations.add(new ConsoleMessageLocation(event.getEntry().getUrl(), event.getEntry().getLineNumber()));
            this.emit(PageEvents.Console, new ConsoleMessage(this.convertConsoleMessageLevel(event.getEntry().getLevel()), event.getEntry().getText(), Collections.emptyList(), locations, null));
        }
    }

    @Override
    public CdpFrame mainFrame() {
        return this.frameManager.mainFrame();
    }

    @Override
    public CdpKeyboard keyboard() {
        return this.keyboard;
    }

    @Override
    public CdpTouchscreen touchscreen() {
        return this.touchscreen;
    }

    @Override
    public Coverage coverage() {
        return this.coverage;
    }

    @Override
    public Tracing tracing() {
        return this.tracing;
    }

    public List<CdpFrame> frames() {
        return this.frameManager.frames();
    }

    @Override
    public List<WebWorker> workers() {
        return new ArrayList<WebWorker>(this.workers.values());
    }

    @Override
    public void setRequestInterception(boolean value) {
        this.frameManager.networkManager().setRequestInterception(value);
    }

    @Override
    public void setBypassServiceWorker(boolean bypass) {
        this.serviceWorkerBypassed = bypass;
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("bypass", bypass);
        this.primaryTargetClient.send("Network.setBypassServiceWorker", params);
    }

    @Override
    @Deprecated
    public void setDragInterception(boolean enabled) {
        this.userDragInterceptionEnabled = enabled;
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("enabled", enabled);
        this.primaryTargetClient.send("Input.setInterceptDrags", params);
    }

    @Override
    public void setOfflineMode(boolean enabled) {
        this.frameManager.networkManager().setOfflineMode(enabled);
    }

    @Override
    public void emulateNetworkConditions(NetworkConditions networkConditions) {
        this.frameManager.networkManager().emulateNetworkConditions(networkConditions);
    }

    @Override
    public void setDefaultNavigationTimeout(int timeout) {
        this._timeoutSettings.setDefaultNavigationTimeout(timeout);
    }

    @Override
    public int getDefaultTimeout() {
        return this._timeoutSettings.timeout();
    }

    @Override
    public int getDefaultNavigationTimeout() {
        return this._timeoutSettings.navigationTimeout();
    }

    @Override
    public void setDefaultTimeout(int timeout) {
        this._timeoutSettings.setDefaultTimeout(timeout);
    }

    @Override
    public JSHandle queryObjects(JSHandle prototypeHandle) throws JsonProcessingException {
        ValidateUtil.assertArg(!prototypeHandle.disposed(), "Prototype JSHandle is disposed!");
        ValidateUtil.assertArg(StringUtil.isNotEmpty(prototypeHandle.remoteObject().getObjectId()), "Prototype JSHandle must not be referencing primitive value");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("prototypeObjectId", prototypeHandle.remoteObject().getObjectId());
        JsonNode response = this.mainFrame().client().send("Runtime.queryObjects", params);
        return this.mainFrame().mainRealm().createJSHandle((RemoteObject)Constant.OBJECTMAPPER.treeToValue((TreeNode)response.get("objects"), RemoteObject.class));
    }

    @Override
    public List<Cookie> cookies() {
        return this.cookies(this.url());
    }

    @Override
    public List<Cookie> cookies(String ... urls) {
        if (urls == null || urls.length == 0) {
            return new ArrayList<Cookie>();
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("urls", urls);
        JsonNode result = this.primaryTargetClient.send("Network.getCookies", params);
        JsonNode cookiesNode = result.get("cookies");
        Iterator elements = cookiesNode.elements();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        while (elements.hasNext()) {
            JsonNode cookieNode = (JsonNode)elements.next();
            Cookie cookie = (Cookie)Constant.OBJECTMAPPER.convertValue((Object)cookieNode, Cookie.class);
            JsonNode partitionKey = cookieNode.path("partitionKey");
            if (!partitionKey.isMissingNode()) {
                cookie.setPartitionKey(partitionKey.get("topLevelSite"));
            } else {
                cookie.setPartitionKey(null);
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public void deleteCookie(DeleteCookiesRequest ... cookies) {
        if (cookies == null || cookies.length == 0) {
            return;
        }
        String pageURL = this.url();
        for (DeleteCookiesRequest cookie : cookies) {
            cookie.setPartitionKey(Helper.convertCookiesPartitionKeyFromPuppeteerToCdp((JsonNode)cookie.getPartitionKey()));
            if (StringUtil.isEmpty(cookie.getUrl()) && pageURL.startsWith("http")) {
                cookie.setUrl(pageURL);
            }
            this.primaryTargetClient.send("Network.deleteCookies", cookie);
            if (!pageURL.startsWith("http") || !Objects.isNull(cookie.getPartitionKey())) continue;
            URI uri = URI.create(pageURL);
            ObjectNode partitionKey = Constant.OBJECTMAPPER.createObjectNode();
            partitionKey.put("topLevelSite", this.getOrigin(uri));
            partitionKey.put("hasCrossSiteAncestor", false);
            cookie.setPartitionKey(partitionKey);
            this.primaryTargetClient.send("Network.deleteCookies", cookie);
        }
    }

    private String getOrigin(URI uri) {
        String scheme = uri.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            return scheme + "://" + uri.getHost();
        }
        return this.getOrigin(URI.create(uri.getSchemeSpecificPart()));
    }

    @Override
    public void setCookie(CookieParam ... cookies) {
        if (cookies == null || cookies.length == 0) {
            return;
        }
        String pageURL = this.url();
        boolean startsWithHTTP = pageURL.startsWith("http");
        ArrayList<CookieParam> cookieParams = new ArrayList<CookieParam>(Arrays.asList(cookies));
        cookieParams.replaceAll(cookie -> {
            if (StringUtil.isEmpty(cookie.getUrl()) && startsWithHTTP) {
                cookie.setUrl(pageURL);
            }
            ValidateUtil.assertArg(!"about:blank".equals(cookie.getUrl()), "Blank page can not have cookie " + cookie.getName());
            if (StringUtil.isNotEmpty(cookie.getUrl())) {
                ValidateUtil.assertArg(!cookie.getUrl().startsWith("data:"), "Data URL page can not have cookie " + cookie.getName());
            }
            return cookie;
        });
        ArrayList<DeleteCookiesRequest> deleteCookiesParameters = new ArrayList<DeleteCookiesRequest>();
        for (CookieParam cookie2 : cookieParams) {
            deleteCookiesParameters.add(new DeleteCookiesRequest(cookie2.getName(), cookie2.getUrl(), cookie2.getDomain(), cookie2.getPath()));
        }
        this.deleteCookie(deleteCookiesParameters.toArray(new DeleteCookiesRequest[0]));
        HashMap<String, ArrayList<CookieParam>> params = new HashMap<String, ArrayList<CookieParam>>();
        params.put("cookies", cookieParams);
        this.primaryTargetClient.send("Network.setCookies", params);
    }

    @Override
    public void exposeFunction(String name, BindingFunction pptrFunction) throws EvaluateException, JsonProcessingException {
        ValidateUtil.assertArg(!this.bindings.containsKey(name), MessageFormat.format("Failed to add page binding with name {0}: window[{1}] already exists!", name, name));
        String source = Helper.evaluationString(this.addPageBinding(), "exposedFun", name, "puppeteer_");
        Binding binding = new Binding(name, pptrFunction, source);
        this.bindings.put(name, binding);
        NewDocumentScriptEvaluation response = this.frameManager.evaluateOnNewDocument(source);
        this.frameManager.addExposedFunctionBinding(binding);
        this.exposedFunctions.put(name, response.getIdentifier());
    }

    @Override
    public void removeExposedFunction(String name) throws JsonProcessingException {
        String exposedFunctionId = this.exposedFunctions.get(name);
        if (exposedFunctionId == null) {
            throw new JvppeteerException("Failed to remove page binding with name '" + name + "' window['" + name + "'] does not exists!");
        }
        this.exposedFunctions.remove(name);
        Binding binging = this.bindings.remove(name);
        this.frameManager.removeScriptToEvaluateOnNewDocument(exposedFunctionId);
        this.frameManager.removeExposedFunctionBinding(binging);
    }

    @Override
    public void authenticate(Credentials credentials) {
        this.frameManager.networkManager().authenticate(credentials);
    }

    @Override
    public void setExtraHTTPHeaders(Map<String, String> headers) {
        this.frameManager.networkManager().setExtraHTTPHeaders(headers);
    }

    @Override
    public void setUserAgent(String userAgent, UserAgentMetadata userAgentMetadata) {
        this.frameManager.networkManager().setUserAgent(userAgent, userAgentMetadata);
    }

    @Override
    public Metrics metrics() throws JsonProcessingException {
        GetMetricsResponse response = (GetMetricsResponse)Constant.OBJECTMAPPER.treeToValue((TreeNode)this.primaryTargetClient.send("Performance.getMetrics"), GetMetricsResponse.class);
        return this.buildMetricsObject(response.getMetrics());
    }

    private void emitMetrics(MetricsEvent event) {
        PageMetrics pageMetrics = new PageMetrics();
        Metrics metrics = this.buildMetricsObject(event.getMetrics());
        pageMetrics.setMetrics(metrics);
        pageMetrics.setTitle(event.getTitle());
        this.emit(PageEvents.Metrics, pageMetrics);
    }

    private Metrics buildMetricsObject(List<Metric> metrics) {
        Metrics result = new Metrics();
        if (ValidateUtil.isNotEmpty(metrics)) {
            for (Metric metric : metrics) {
                if (!Constant.supportedMetrics.contains(metric.getName())) continue;
                switch (metric.getName()) {
                    case "Timestamp": {
                        result.setTimestamp(metric.getValue());
                        break;
                    }
                    case "Documents": {
                        result.setDocuments(metric.getValue());
                        break;
                    }
                    case "Frames": {
                        result.setFrames(metric.getValue());
                        break;
                    }
                    case "JSEventListeners": {
                        result.setJSEventListeners(metric.getValue());
                        break;
                    }
                    case "Nodes": {
                        result.setNodes(metric.getValue());
                        break;
                    }
                    case "LayoutCount": {
                        result.setLayoutCount(metric.getValue());
                        break;
                    }
                    case "RecalcStyleCount": {
                        result.setRecalcStyleCount(metric.getValue());
                        break;
                    }
                    case "LayoutDuration": {
                        result.setLayoutDuration(metric.getValue());
                        break;
                    }
                    case "RecalcStyleDuration": {
                        result.setRecalcStyleDuration(metric.getValue());
                        break;
                    }
                    case "ScriptDuration": {
                        result.setScriptDuration(metric.getValue());
                        break;
                    }
                    case "TaskDuration": {
                        result.setTaskDuration(metric.getValue());
                        break;
                    }
                    case "JSHeapUsedSize": {
                        result.setJSHeapUsedSize(metric.getValue());
                        break;
                    }
                    case "JSHeapTotalSize": {
                        result.setJSHeapTotalSize(metric.getValue());
                    }
                }
            }
        }
        return result;
    }

    private void handleException(ExceptionThrownEvent event) {
        this.emit(PageEvents.PageError, Helper.createClientError(event.getExceptionDetails()));
    }

    private void onConsoleAPI(IsolatedWorld world, ConsoleAPICalledEvent event) {
        ArrayList<JSHandle> values = new ArrayList<JSHandle>();
        if (ValidateUtil.isNotEmpty(event.getArgs())) {
            for (int i = 0; i < event.getArgs().size(); ++i) {
                RemoteObject arg = event.getArgs().get(i);
                values.add(world.createJSHandle(arg));
            }
        }
        this.addConsoleMessage(this.convertConsoleMessageLevel(event.getType()), values, event.getStackTrace());
    }

    private void addConsoleMessage(ConsoleMessageType type, List<JSHandle> args, StackTrace stackTrace) {
        if (this.listenerCount(PageEvents.Console) == 0) {
            args.forEach(JSHandle::dispose);
            return;
        }
        ArrayList<String> textTokens = new ArrayList<String>();
        for (JSHandle jSHandle : args) {
            RemoteObject remoteObject = jSHandle.remoteObject();
            if (StringUtil.isNotEmpty(remoteObject.getObjectId())) {
                textTokens.add(jSHandle.toString());
                continue;
            }
            textTokens.add(Helper.valueFromRemoteObject(remoteObject) + "");
        }
        ArrayList<ConsoleMessageLocation> stackTraceLocations = new ArrayList<ConsoleMessageLocation>();
        if (stackTrace != null && ValidateUtil.isNotEmpty(stackTrace.getCallFrames())) {
            for (CallFrame callFrame : stackTrace.getCallFrames()) {
                stackTraceLocations.add(new ConsoleMessageLocation(callFrame.getUrl(), callFrame.getLineNumber(), callFrame.getColumnNumber()));
            }
        }
        ConsoleMessage consoleMessage = new ConsoleMessage(type, String.join((CharSequence)" ", textTokens), args, stackTraceLocations, null);
        this.emit(PageEvents.Console, consoleMessage);
    }

    @Override
    public Response reload(WaitForOptions options) {
        options.setIgnoreSameDocumentNavigation(true);
        return this.waitForNavigation(options, () -> this.primaryTargetClient.send("Page.reload", null, null, false));
    }

    @Override
    public CDPSession createCDPSession() {
        return this.target().createCDPSession();
    }

    @Override
    public Response goBack(WaitForOptions options) throws JsonProcessingException {
        return this.go(-1, options);
    }

    @Override
    public Response goForward(WaitForOptions options) throws JsonProcessingException {
        return this.go(1, options);
    }

    private Response go(int delta, WaitForOptions options) throws JsonProcessingException {
        JsonNode historyNode = this.primaryTargetClient.send("Page.getNavigationHistory");
        GetNavigationHistoryResponse history = (GetNavigationHistoryResponse)Constant.OBJECTMAPPER.treeToValue((TreeNode)historyNode, GetNavigationHistoryResponse.class);
        NavigationEntry entry = history.getEntries().get(history.getCurrentIndex() + delta);
        if (entry == null) {
            return null;
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("entryId", entry.getId());
        this.primaryTargetClient.send("Page.navigateToHistoryEntry", params, null, false);
        return this.waitForNavigation(options);
    }

    @Override
    public void bringToFront() {
        this.primaryTargetClient.send("Page.bringToFront");
    }

    @Override
    public void setJavaScriptEnabled(boolean enabled) {
        this.emulationManager.setJavaScriptEnabled(enabled);
    }

    @Override
    public void setBypassCSP(boolean enabled) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("enabled", enabled);
        this.primaryTargetClient.send("Page.setBypassCSP", params);
    }

    @Override
    public void emulateMediaType(MediaType type) {
        this.emulationManager.emulateMediaType(type);
    }

    @Override
    public void emulateCPUThrottling(double factor) {
        this.emulationManager.emulateCPUThrottling(factor);
    }

    @Override
    public void emulateMediaFeatures(List<MediaFeature> features) {
        this.emulationManager.emulateMediaFeatures(features);
    }

    @Override
    public void emulateTimezone(String timezoneId) {
        this.emulationManager.emulateTimezone(timezoneId);
    }

    @Override
    public void emulateIdleState(IdleOverridesState.Overrides overrides) {
        this.emulationManager.emulateIdleState(overrides);
    }

    @Override
    public void emulateVisionDeficiency(VisionDeficiency type) {
        this.emulationManager.emulateVisionDeficiency(type);
    }

    @Override
    public void setViewport(Viewport viewport) {
        boolean needsReload = this.emulationManager.emulateViewport(viewport);
        this.viewport = viewport;
        if (needsReload) {
            this.reload(new WaitForOptions());
        }
    }

    @Override
    public Viewport viewport() {
        return this.viewport;
    }

    @Override
    public NewDocumentScriptEvaluation evaluateOnNewDocument(String pptrFunction, EvaluateType type, Object ... args) throws JsonProcessingException {
        String source;
        if (Objects.equals((Object)EvaluateType.STRING, (Object)type)) {
            ValidateUtil.assertArg(args.length == 0, "Cannot evaluate a string with arguments");
            source = pptrFunction;
        } else {
            source = Helper.evaluationString(pptrFunction, args);
        }
        return this.frameManager.evaluateOnNewDocument(source);
    }

    @Override
    public void removeScriptToEvaluateOnNewDocument(String identifier) {
        HashMap<String, String> identifierKeys = new HashMap<String, String>();
        identifierKeys.put("identifier", identifier);
        this.primaryTargetClient.send("Page.removeScriptToEvaluateOnNewDocument", identifierKeys);
    }

    @Override
    public void setCacheEnabled(boolean enabled) {
        this.frameManager.networkManager().setCacheEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _screenshot(ScreenshotOptions options) {
        Map<String, Object> params = ParamsFactory.create();
        try {
            ScreenshotClip clip;
            if (options.getOmitBackground() && (ImageType.PNG.equals((Object)options.getType()) || ImageType.WEBP.equals((Object)options.getType()))) {
                this.emulationManager.setTransparentBackgroundColor();
            }
            if ((clip = options.getClip()) != null && !options.getCaptureBeyondViewport()) {
                Object response = this.mainFrame().isolatedRealm().evaluate("() => {\n          const {\n            height,\n            pageLeft: x,\n            pageTop: y,\n            width,\n          } = window.visualViewport;\n          return {x, y, height, width};\n        }", null);
                JsonNode responseNode = Constant.OBJECTMAPPER.readTree(Constant.OBJECTMAPPER.writeValueAsString(response));
                clip = this.getIntersectionRect(clip, responseNode);
            }
            params.put("format", options.getType().toString());
            if (options.getOptimizeForSpeed()) {
                params.put("optimizeForSpeed", options.getOptimizeForSpeed());
            }
            if (options.getQuality() != null) {
                params.put("quality", Math.round(options.getQuality()));
            }
            if (clip != null) {
                params.put("clip", clip);
            }
            if (!options.getFromSurface()) {
                params.put("fromSurface", options.getFromSurface());
            }
            params.put("captureBeyondViewport", options.getCaptureBeyondViewport());
            JsonNode result = this.primaryTargetClient.send("Page.captureScreenshot", params);
            String data = result.get("data").asText();
            byte[] buffer = Base64.getDecoder().decode(data);
            if (StringUtil.isNotEmpty(options.getPath())) {
                Files.write(Paths.get(options.getPath(), new String[0]), buffer, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            String string = data;
            return string;
        }
        catch (Exception var) {
            LOGGER.error("_screenshot error: ", (Throwable)var);
        }
        finally {
            if (options.getOmitBackground() && (ImageType.PNG.equals((Object)options.getType()) || ImageType.WEBP.equals((Object)options.getType()))) {
                this.emulationManager.resetDefaultBackgroundColor();
            }
        }
        return null;
    }

    private ScreenshotClip getIntersectionRect(ScreenshotClip clip, JsonNode viewport) {
        double x = Math.max(clip.getX(), viewport.get("x").asDouble());
        double y = Math.max(clip.getY(), viewport.get("y").asDouble());
        return new ScreenshotClip(x, y, Math.max(Math.min(clip.getX() + clip.getWidth(), viewport.get("x").asDouble() + viewport.get("width").asDouble()) - x, 0.0), Math.max(Math.min(clip.getY() + clip.getHeight(), viewport.get("y").asDouble() + viewport.get("height").asDouble()) - y, 0.0), 1.0);
    }

    @Override
    public byte[] pdf(PDFOptions options, LengthUnit lengthUnit) throws IOException {
        JsonNode handle;
        Number marginRight;
        Number marginBottom;
        Number marginLeft;
        double paperWidth = 8.5;
        double paperHeight = 11.0;
        if (options.getFormat() != null) {
            PaperFormats format = options.getFormat();
            paperWidth = format.getWidth();
            paperHeight = format.getHeight();
        } else {
            Double height;
            Double width = this.convertPrintParameterToInches(options.getWidth(), lengthUnit);
            if (width != null) {
                paperWidth = width;
            }
            if ((height = this.convertPrintParameterToInches(options.getHeight(), lengthUnit)) != null) {
                paperHeight = height;
            }
        }
        PDFMargin margin = options.getMargin();
        Number marginTop = this.convertPrintParameterToInches(margin.getTop(), lengthUnit);
        if (marginTop == null) {
            marginTop = 0;
        }
        if ((marginLeft = this.convertPrintParameterToInches(margin.getLeft(), lengthUnit)) == null) {
            marginLeft = 0;
        }
        if ((marginBottom = this.convertPrintParameterToInches(margin.getBottom(), lengthUnit)) == null) {
            marginBottom = 0;
        }
        if ((marginRight = this.convertPrintParameterToInches(margin.getRight(), lengthUnit)) == null) {
            marginRight = 0;
        }
        if (options.getOutline()) {
            options.setTagged(true);
        }
        if (options.getOmitBackground()) {
            this.emulationManager.setTransparentBackgroundColor();
        }
        if (options.getWaitForFonts()) {
            this.mainFrame().evaluate("() => { return document.fonts.ready;}");
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("transferMode", "ReturnAsStream");
        params.put("landscape", options.getLandscape());
        params.put("displayHeaderFooter", options.getDisplayHeaderFooter());
        params.put("headerTemplate", options.getHeaderTemplate());
        params.put("footerTemplate", options.getFooterTemplate());
        params.put("printBackground", options.getPrintBackground());
        params.put("scale", options.getScale());
        params.put("paperWidth", paperWidth);
        params.put("paperHeight", paperHeight);
        params.put("marginTop", marginTop);
        params.put("marginBottom", marginBottom);
        params.put("marginLeft", marginLeft);
        params.put("marginRight", marginRight);
        params.put("pageRanges", options.getPageRanges());
        params.put("preferCSSPageSize", options.getPreferCSSPageSize());
        params.put("generateTaggedPDF", options.getTagged());
        params.put("generateDocumentOutline", options.getOutline());
        JsonNode result = this.primaryTargetClient.send("Page.printToPDF", params);
        if (options.getOmitBackground()) {
            this.emulationManager.resetDefaultBackgroundColor();
        }
        ValidateUtil.assertArg((handle = result.get("stream")) != null, "Page.printToPDF result has no stream handle. Please check your chrome version. result=" + result);
        return Helper.readProtocolStream(this.primaryTargetClient, handle.asText(), options.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean runBeforeUnload) {
        BrowserContext browserContext = this.browserContext();
        synchronized (browserContext) {
            ValidateUtil.assertArg(this.primaryTargetClient.connection() != null, "Protocol error: Connection closed. Most likely the page has been closed.");
            if (runBeforeUnload) {
                this.primaryTargetClient.send("Page.close");
            } else {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("targetId", this.primaryTarget.getTargetId());
                this.primaryTargetClient.connection().send("Target.closeTarget", params);
                this.tabTarget.waitForTargetClose();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public CdpMouse mouse() {
        return this.mouse;
    }

    public static CdpPage create(CDPSession client, CdpTarget target, Viewport viewport) {
        CdpPage page = new CdpPage(client, target);
        page.initialize();
        if (viewport != null) {
            page.setViewport(viewport);
        }
        return page;
    }

    private void onBindingCalled(IsolatedWorld world, BindingCalledEvent event) {
        BindingPayload payload;
        String payloadStr = event.getPayload();
        try {
            payload = (BindingPayload)Constant.OBJECTMAPPER.readValue(payloadStr, BindingPayload.class);
        }
        catch (JsonProcessingException e) {
            return;
        }
        if (!"exposedFun".equals(payload.getType())) {
            return;
        }
        if (world.context() == null) {
            return;
        }
        Binding binding = this.bindings.get(payload.getName());
        Optional.ofNullable(binding).ifPresent(b -> b.run(world.context(), payload.getSeq(), payload.getArgs(), payload.getIsTrivial()));
    }

    private void onDialog(JavascriptDialogOpeningEvent event) {
        CdpDialog dialog = new CdpDialog(this.primaryTargetClient, event.getType(), event.getMessage(), event.getDefaultPrompt());
        this.emit(PageEvents.Dialog, dialog);
    }

    private String addPageBinding() {
        return "function addPageBinding(type, name, prefix) {\n\n\n\n\n    if (globalThis[name]) {\n        return;\n    }\n\n    Object.assign(globalThis, {\n        [name](...args) {\n\n\n            const callPuppeteer = globalThis[name];\n            callPuppeteer.args ??= new Map();\n            callPuppeteer.callbacks ??= new Map();\n            const seq = (callPuppeteer.lastSeq ?? 0) + 1;\n            callPuppeteer.lastSeq = seq;\n            callPuppeteer.args.set(seq, args);\n\n\n            globalThis[prefix + name](JSON.stringify({\n                type,\n                name,\n                seq,\n                args,\n                isTrivial: !args.some(value => {\n                    return value instanceof Node;\n                }),\n            }));\n            return new Promise((resolve, reject) => {\n                callPuppeteer.callbacks.set(seq, {\n                    resolve(value) {\n                        callPuppeteer.args.delete(seq);\n                        resolve(value);\n                    },\n                    reject(value) {\n                        callPuppeteer.args.delete(seq);\n                        reject(value);\n                    },\n                });\n            });\n        },\n    });\n}";
    }

    private ConsoleMessageType convertConsoleMessageLevel(String method) {
        if ("warning".equals(method)) {
            return ConsoleMessageType.warn;
        }
        return ConsoleMessageType.valueOf(method);
    }

    public void setIsDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public Accessibility accessibility() {
        return this.mainFrame().accessibility();
    }
}

