/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.core.Request;
import com.ruiyun.jvppeteer.cdp.core.CdpResponse;
import com.ruiyun.jvppeteer.cdp.entities.ContinueRequestOverrides;
import com.ruiyun.jvppeteer.cdp.entities.ErrorReasons;
import com.ruiyun.jvppeteer.cdp.entities.HeaderEntry;
import com.ruiyun.jvppeteer.cdp.entities.Initiator;
import com.ruiyun.jvppeteer.cdp.entities.ResourceType;
import com.ruiyun.jvppeteer.cdp.entities.ResponseForRequest;
import com.ruiyun.jvppeteer.cdp.events.RequestWillBeSentEvent;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.util.Base64Util;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CdpRequest
extends Request {
    private final String id;
    private final String urlFragment;
    private CDPSession client;
    private volatile boolean isNavigationRequest;
    private final String url;
    private final ResourceType resourceType;
    private final String method;
    private final boolean hasPostData;
    private final String postData;
    private volatile List<HeaderEntry> headers = new ArrayList<HeaderEntry>();
    private final Frame frame;
    private final Initiator initiator;

    public CdpRequest(CDPSession client, Frame frame, String interceptionId, boolean allowInterception, RequestWillBeSentEvent event, List<Request> redirectChain) {
        this.client = client;
        this.id = event.getRequestId();
        if (event.getRequestId() != null) {
            if (event.getRequestId().equals(event.getLoaderId()) && "Document".equals(event.getType())) {
                this.isNavigationRequest = true;
            }
        } else {
            this.isNavigationRequest = false;
        }
        this.interceptionId = interceptionId;
        this.url = event.getRequest().getUrl();
        this.urlFragment = event.getRequest().getUrlFragment();
        this.resourceType = StringUtil.isEmpty(event.getType()) ? ResourceType.Other : ResourceType.valueOf(event.getType());
        this.method = event.getRequest().getMethod();
        this.postData = event.getRequest().getPostData();
        this.hasPostData = event.getRequest().getHasPostData();
        this.frame = frame;
        this.redirectChain = redirectChain;
        this.initiator = event.getInitiator();
        this.interception.setEnabled(allowInterception);
        for (Map.Entry<String, String> entry : event.getRequest().getHeaders().entrySet()) {
            this.headers.add(new HeaderEntry(entry.getKey().toLowerCase(), entry.getValue()));
        }
    }

    @Override
    public CDPSession client() {
        return this.client;
    }

    @Override
    public String url() {
        return this.url(false);
    }

    public String url(boolean withFragment) {
        return withFragment ? this.url + this.urlFragment : this.url;
    }

    @Override
    public ResourceType resourceType() {
        return this.resourceType;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String postData() {
        return this.postData;
    }

    @Override
    public boolean hasPostData() {
        return this.hasPostData;
    }

    @Override
    public String fetchPostData() {
        Map<String, Object> params = ParamsFactory.create();
        params.put("requestId", this.id);
        JsonNode response = this.client.send("Network.getRequestPostData", params);
        return response.get("postData").asText();
    }

    @Override
    public List<HeaderEntry> headers() {
        return this.headers;
    }

    @Override
    public CdpResponse response() {
        return this.response;
    }

    @Override
    public Frame frame() {
        return this.frame;
    }

    public void setHeaders(List<HeaderEntry> headers) {
        this.headers = headers;
    }

    @Override
    public boolean isNavigationRequest() {
        return this.isNavigationRequest;
    }

    @Override
    public Initiator initiator() {
        return this.initiator;
    }

    public List<Request> redirectChain() {
        return this.redirectChain;
    }

    @Override
    public String failure() {
        return this.failureText;
    }

    @Override
    public void _continue(ContinueRequestOverrides overrides) {
        this.interception.setHandled(true);
        ValidateUtil.assertArg(StringUtil.isNotEmpty(this.interceptionId), "HTTPRequest is missing _interceptionId needed for Fetch.continueRequest");
        Map<String, Object> params = ParamsFactory.create();
        params.put("requestId", this.interceptionId);
        params.put("url", overrides.getUrl());
        params.put("method", overrides.getMethod());
        if (StringUtil.isNotEmpty(overrides.getPostData())) {
            params.put("postData", new String(Base64.getEncoder().encode(overrides.getPostData().getBytes()), StandardCharsets.UTF_8));
        } else {
            params.put("postData", "");
        }
        params.put("headers", this.filterHeaders(overrides.getHeaders()));
        try {
            this.client.send("Fetch.continueRequest", params);
        }
        catch (Exception e) {
            this.interception.setHandled(false);
            this.handleError(e);
        }
    }

    @Override
    public void _respond(ResponseForRequest response) {
        this.interception.setHandled(true);
        String base64Body = null;
        int contentLength = 0;
        if (StringUtil.isNotEmpty(response.getBody())) {
            byte[] byteBody = response.getBody().getBytes(StandardCharsets.UTF_8);
            base64Body = Base64Util.encode(byteBody);
            contentLength = byteBody.length;
        }
        List<HeaderEntry> responseHeaders = CdpRequest.headers(response, base64Body, contentLength);
        ValidateUtil.assertArg(StringUtil.isNotEmpty(this.interceptionId), "HTTPRequest is missing _interceptionId needed for Fetch.fulfillRequest");
        Map<String, Object> params = ParamsFactory.create();
        params.put("requestId", this.interceptionId);
        params.put("responseCode", response.getStatus());
        params.put("responsePhrase", STATUS_TEXTS.get(response.getStatus()));
        params.put("responseHeaders", this.filterHeaders(responseHeaders));
        if (Objects.nonNull(base64Body)) {
            params.put("body", base64Body);
        }
        try {
            this.client.send("Fetch.fulfillRequest", params);
        }
        catch (Exception e) {
            this.interception.setHandled(false);
            this.handleError(e);
        }
    }

    private static List<HeaderEntry> headers(ResponseForRequest response, String base64Body, int contentLength) {
        ArrayList<HeaderEntry> responseHeaders = new ArrayList<HeaderEntry>();
        boolean hasContentLength = false;
        if (ValidateUtil.isNotEmpty(response.getHeaders())) {
            for (HeaderEntry header : response.getHeaders()) {
                String name = header.getName().toLowerCase();
                responseHeaders.add(new HeaderEntry(name, header.getValue()));
                if (!name.equals("content-length")) continue;
                hasContentLength = true;
            }
        }
        if (StringUtil.isNotEmpty(response.getContentType())) {
            responseHeaders.add(new HeaderEntry("content-type", response.getContentType()));
        }
        if (base64Body != null && !hasContentLength) {
            responseHeaders.add(new HeaderEntry("content-length", String.valueOf(contentLength)));
        }
        return responseHeaders;
    }

    @Override
    public void _abort(ErrorReasons errorCode) {
        this.interception.setHandled(true);
        ValidateUtil.assertArg(StringUtil.isNotEmpty(this.interceptionId), "HTTPRequest is missing _interceptionId needed for Fetch.fulfillRequest");
        String errorReason = errorCode.getName();
        Map<String, Object> params = ParamsFactory.create();
        params.put("requestId", this.interceptionId);
        params.put("errorReason", errorReason);
        try {
            this.client.send("Fetch.failRequest", params);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public String interceptionId() {
        return this.interceptionId;
    }

    private List<HeaderEntry> filterHeaders(List<HeaderEntry> headers) {
        if (headers == null) {
            return null;
        }
        Iterator<HeaderEntry> iterator = headers.iterator();
        while (iterator.hasNext()) {
            HeaderEntry next = iterator.next();
            if (!StringUtil.isEmpty(next.getValue())) continue;
            iterator.remove();
        }
        return headers;
    }

    protected void setResponse(CdpResponse response) {
        this.response = response;
    }

    @Override
    public String id() {
        return this.id;
    }

    protected void setFailureText(String failureText) {
        this.failureText = failureText;
    }

    public boolean fromMemoryCache() {
        return this.fromMemoryCache;
    }

    public void setClient(CDPSession client) {
        this.client = client;
    }
}

