/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.cdp.core.CSSCoverage;
import com.ruiyun.jvppeteer.cdp.core.JSCoverage;
import com.ruiyun.jvppeteer.cdp.entities.CSSCoverageOptions;
import com.ruiyun.jvppeteer.cdp.entities.CoverageEntry;
import com.ruiyun.jvppeteer.cdp.entities.CoveragePoint;
import com.ruiyun.jvppeteer.cdp.entities.CoverageRange;
import com.ruiyun.jvppeteer.cdp.entities.JSCoverageEntry;
import com.ruiyun.jvppeteer.cdp.entities.JSCoverageOptions;
import com.ruiyun.jvppeteer.cdp.entities.Range;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Coverage {
    private final CSSCoverage cssCoverage;
    private final JSCoverage jsCoverage;

    public Coverage(CDPSession client) {
        this.cssCoverage = new CSSCoverage(client);
        this.jsCoverage = new JSCoverage(client);
    }

    public void updateClient(CDPSession client) {
        this.cssCoverage.updateClient(client);
        this.jsCoverage.updateClient(client);
    }

    public void startJSCoverage() {
        this.jsCoverage.start(new JSCoverageOptions());
    }

    public void startJSCoverage(JSCoverageOptions options) {
        this.jsCoverage.start(options);
    }

    public List<JSCoverageEntry> stopJSCoverage() throws JsonProcessingException {
        return this.jsCoverage.stop();
    }

    public void startCSSCoverage() {
        this.cssCoverage.start(new CSSCoverageOptions());
    }

    public void startCSSCoverage(CSSCoverageOptions options) {
        this.cssCoverage.start(options);
    }

    public List<CoverageEntry> stopCSSCoverage() {
        return this.cssCoverage.stop();
    }

    public static List<Range> convertToDisjointRanges(List<CoverageRange> nestedRanges) {
        ArrayList<CoveragePoint> points = new ArrayList<CoveragePoint>();
        if (ValidateUtil.isNotEmpty(nestedRanges)) {
            for (CoverageRange range2 : nestedRanges) {
                points.add(new CoveragePoint(range2.getStartOffset(), 0.0, range2));
                points.add(new CoveragePoint(range2.getEndOffset(), 1.0, range2));
            }
        }
        points.sort((a, b) -> {
            if (a.getOffset() != b.getOffset()) {
                return (int)(a.getOffset() - b.getOffset());
            }
            if (a.getType() != b.getType()) {
                return (int)(b.getType() - a.getType());
            }
            double aLength = a.getRange().getEndOffset() - a.getRange().getStartOffset();
            double bLength = b.getRange().getEndOffset() - b.getRange().getStartOffset();
            if (a.getType() == 0.0) {
                return (int)(bLength - aLength);
            }
            return (int)(aLength - bLength);
        });
        LinkedList<Double> hitCountStack = new LinkedList<Double>();
        ArrayList<Range> results = new ArrayList<Range>();
        double lastOffset = 0.0;
        for (CoveragePoint point : points) {
            if (!hitCountStack.isEmpty() && lastOffset < point.getOffset() && (Double)hitCountStack.get(hitCountStack.size() - 1) > 0.0) {
                Range lastResult;
                Range range3 = lastResult = !results.isEmpty() ? (Range)results.get(results.size() - 1) : null;
                if (lastResult != null && lastResult.getEnd() == lastOffset) {
                    lastResult.setEnd(point.getOffset());
                } else {
                    results.add(new Range(lastOffset, point.getOffset()));
                }
            }
            lastOffset = point.getOffset();
            if (point.getType() == 0.0) {
                hitCountStack.offer(point.getRange().getCount());
                continue;
            }
            hitCountStack.poll();
        }
        return results.stream().filter(range -> range.getEnd() - range.getStart() > 0.0).collect(Collectors.toList());
    }
}

