/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.api.events.FrameEvents;
import com.ruiyun.jvppeteer.cdp.core.CdpFrame;
import com.ruiyun.jvppeteer.cdp.core.CdpPage;
import com.ruiyun.jvppeteer.cdp.core.CdpTarget;
import com.ruiyun.jvppeteer.cdp.core.ExecutionContext;
import com.ruiyun.jvppeteer.cdp.core.FrameTree;
import com.ruiyun.jvppeteer.cdp.core.FrameTreeEvent;
import com.ruiyun.jvppeteer.cdp.core.IsolatedWorld;
import com.ruiyun.jvppeteer.cdp.core.NetworkManager;
import com.ruiyun.jvppeteer.cdp.entities.Binding;
import com.ruiyun.jvppeteer.cdp.entities.ExecutionContextDescription;
import com.ruiyun.jvppeteer.cdp.entities.FramePayload;
import com.ruiyun.jvppeteer.cdp.entities.NewDocumentScriptEvaluation;
import com.ruiyun.jvppeteer.cdp.entities.PreloadScript;
import com.ruiyun.jvppeteer.cdp.events.LifecycleEvent;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.DeviceRequestPromptManager;
import com.ruiyun.jvppeteer.common.FrameProvider;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.TargetCloseException;
import com.ruiyun.jvppeteer.transport.CdpCDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameManager
extends EventEmitter<FrameManagerEvent>
implements FrameProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameManager.class);
    private final CdpPage page;
    private final NetworkManager networkManager;
    private final TimeoutSettings timeoutSettings;
    private final Set<String> isolatedWorlds = new HashSet<String>();
    private volatile CDPSession client;
    private final Map<String, PreloadScript> scriptsToEvaluateOnNewDocument = new HashMap<String, PreloadScript>();
    private final Set<Binding> bindings = new HashSet<Binding>();
    private final FrameTree<CdpFrame> frameTree = new FrameTree();
    private final Set<String> frameNavigatedReceived = new HashSet<String>();
    private final Map<CDPSession, DeviceRequestPromptManager> deviceRequestPromptManagerMap = new WeakHashMap<CDPSession, DeviceRequestPromptManager>();
    private volatile AwaitableResult<Boolean> frameTreeHandled;

    public FrameManager(CDPSession client, CdpPage page, TimeoutSettings timeoutSettings) {
        this.client = client;
        this.page = page;
        this.networkManager = new NetworkManager(this, page.browser().isNetworkEnabled());
        this.timeoutSettings = timeoutSettings;
        this.setupEventListeners(this.client);
        client.once(ConnectionEvents.CDPSession_Disconnected, ignored -> {
            try {
                this.onClientDisconnect();
            }
            catch (Exception e) {
                LOGGER.error("onClientDisconnect error", (Throwable)e);
            }
        });
    }

    public CdpPage page() {
        return this.page;
    }

    private void onClientDisconnect() {
        CdpFrame mainFrame = this.frameTree.getMainFrame();
        if (mainFrame == null) {
            return;
        }
        if (!this.page().browser().connected()) {
            this.removeFramesRecursively(mainFrame);
            return;
        }
        mainFrame.childFrames().forEach(this::removeFramesRecursively);
        AwaitableResult swappedSubject = AwaitableResult.create();
        Consumer<Object> onSwapped = ignored -> swappedSubject.onSuccess(true);
        try {
            mainFrame.once(FrameEvents.FrameSwappedByActivation, onSwapped);
            swappedSubject.waiting(100, TimeUnit.MILLISECONDS);
        }
        catch (Exception err) {
            this.removeFramesRecursively(mainFrame);
        }
    }

    public void swapFrameTree(CDPSession client) {
        this.client = client;
        CdpFrame frame = this.frameTree.getMainFrame();
        if (frame != null) {
            this.frameNavigatedReceived.add(((CdpCDPSession)this.client).getTarget().getTargetId());
            this.frameTree.removeFrame(frame);
            frame.updateId(((CdpCDPSession)this.client).getTarget().getTargetId());
            this.frameTree.addFrame(frame);
            frame.updateClient(client);
        }
        this.setupEventListeners(client);
        client.once(ConnectionEvents.CDPSession_Disconnected, ignored -> {
            try {
                this.onClientDisconnect();
            }
            catch (Exception e) {
                LOGGER.error("onClientDisconnect error", (Throwable)e);
            }
        });
        this.initialize(client, frame);
        this.networkManager.addClient(client);
        if (frame != null) {
            frame.emit(FrameEvents.FrameSwappedByActivation, true);
        }
    }

    public void registerSpeculativeSession(CdpCDPSession client) {
        this.networkManager.addClient(client);
    }

    private void setupEventListeners(CDPSession session) {
        session.on(ConnectionEvents.Page_frameAttached, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameAttached(session, event.getFrameId(), event.getParentFrameId());
        });
        session.on(ConnectionEvents.Page_frameNavigated, event -> {
            this.frameNavigatedReceived.add(event.getFrame().getId());
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameNavigated(event.getFrame(), event.getType());
        });
        session.on(ConnectionEvents.Page_navigatedWithinDocument, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameNavigatedWithinDocument(event.getFrameId(), event.getUrl());
        });
        session.on(ConnectionEvents.Page_frameDetached, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameDetached(event.getFrameId(), event.getReason());
        });
        session.on(ConnectionEvents.Page_frameStartedLoading, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameStartedLoading(event.getFrameId());
        });
        session.on(ConnectionEvents.Page_frameStoppedLoading, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameStoppedLoading(event.getFrameId());
        });
        session.on(ConnectionEvents.Runtime_executionContextCreated, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onExecutionContextCreated(event.getContext(), session);
        });
        session.on(ConnectionEvents.Page_lifecycleEvent, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onLifecycleEvent((LifecycleEvent)event);
        });
    }

    public CDPSession client() {
        return this.client;
    }

    public TimeoutSettings timeoutSettings() {
        return this.timeoutSettings;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public void initialize(CDPSession client, CdpFrame frame) {
        try {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(handle -> handle.onSuccess(true));
            this.frameTreeHandled = AwaitableResult.create();
            this.networkManager.addClient(client);
            client.send("Page.enable", null, null, false);
            JsonNode result = client.send("Page.getFrameTree");
            FrameTreeEvent frameTree = (FrameTreeEvent)Constant.OBJECTMAPPER.treeToValue((TreeNode)result.get("frameTree"), FrameTreeEvent.class);
            this.handleFrameTree(client, frameTree);
            Optional.ofNullable(this.frameTreeHandled).ifPresent(handle -> handle.onSuccess(true));
            Map<String, Object> params = ParamsFactory.create();
            params.put("enabled", true);
            client.send("Page.setLifecycleEventsEnabled", params, null, false);
            client.send("Runtime.enable");
            this.createIsolatedWorld(client, "__puppeteer_utility_world__3.4.0");
            if (frame != null) {
                this.scriptsToEvaluateOnNewDocument.values().forEach(frame::addPreloadScript);
                for (Binding binding : this.bindings) {
                    frame.addExposedFunctionBinding(binding);
                }
            }
        }
        catch (Exception e) {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(handle -> handle.onSuccess(true));
            if (e instanceof TargetCloseException) {
                return;
            }
            Helper.throwError(e);
        }
    }

    public CdpFrame mainFrame() {
        CdpFrame mainFrame = this.frameTree.getMainFrame();
        Objects.requireNonNull(mainFrame, "Requesting main frame too early!");
        return mainFrame;
    }

    public List<CdpFrame> frames() {
        return new ArrayList<CdpFrame>(this.frameTree.frames());
    }

    @Override
    public CdpFrame frame(String frameId) {
        return this.frameTree.getById(frameId);
    }

    public void addExposedFunctionBinding(Binding binding) throws JsonProcessingException, EvaluateException {
        this.bindings.add(binding);
        for (CdpFrame frame : this.frames()) {
            frame.addExposedFunctionBinding(binding);
        }
    }

    public void removeExposedFunctionBinding(Binding binding) throws JsonProcessingException {
        this.bindings.remove(binding);
        for (CdpFrame frame : this.frames()) {
            frame.removeExposedFunctionBinding(binding);
        }
    }

    public NewDocumentScriptEvaluation evaluateOnNewDocument(final String source) {
        JsonNode response = this.mainFrame().client().send("Page.addScriptToEvaluateOnNewDocument", new HashMap<String, Object>(){
            {
                this.put("source", source);
            }
        });
        String identifier = response.get("identifier").asText();
        PreloadScript preloadScript = new PreloadScript(this.mainFrame(), identifier, source);
        this.scriptsToEvaluateOnNewDocument.put(identifier, preloadScript);
        for (CdpFrame frame : this.frames()) {
            frame.addPreloadScript(preloadScript);
        }
        return new NewDocumentScriptEvaluation(identifier);
    }

    public void removeScriptToEvaluateOnNewDocument(String identifier) {
        PreloadScript preloadScript = this.scriptsToEvaluateOnNewDocument.get(identifier);
        if (preloadScript == null) {
            throw new JvppeteerException("Script to evaluate on new document with id " + identifier + " not found");
        }
        this.scriptsToEvaluateOnNewDocument.remove(identifier);
        for (CdpFrame frame : this.frames()) {
            final String identifier2 = preloadScript.getIdForFrame(frame);
            if (StringUtil.isEmpty(identifier2)) {
                return;
            }
            try {
                frame.client().send("Page.removeScriptToEvaluateOnNewDocument", new HashMap<String, Object>(){
                    {
                        this.put("identifier", identifier2);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Page.removeScriptToEvaluateOnNewDocument error", (Throwable)e);
            }
        }
    }

    public void onAttachedToTarget(CdpTarget target) {
        if (!"iframe".equals(target.getTargetInfo().getType())) {
            return;
        }
        CdpFrame frame = this.frame(target.getTargetInfo().getTargetId());
        if (frame != null) {
            frame.updateClient(target.session());
        }
        this.setupEventListeners(target.session());
        this.initialize(target.session(), frame);
    }

    public DeviceRequestPromptManager deviceRequestPromptManager(CDPSession client) {
        DeviceRequestPromptManager manager = this.deviceRequestPromptManagerMap.get(client);
        if (manager == null) {
            manager = new DeviceRequestPromptManager(client, this.timeoutSettings);
            this.deviceRequestPromptManagerMap.put(client, manager);
        }
        return manager;
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        CdpFrame frame = this.frame(event.getFrameId());
        if (frame == null) {
            return;
        }
        frame.onLifecycleEvent(event.getLoaderId(), event.getName());
        this.emit(FrameManagerEvent.LifecycleEvent, frame);
        frame.emit(FrameEvents.LifecycleEvent, true);
    }

    private void onFrameStoppedLoading(String frameId) {
        CdpFrame frame = this.frame(frameId);
        if (frame == null) {
            return;
        }
        frame.onLoadingStopped();
        this.emit(FrameManagerEvent.LifecycleEvent, frame);
        frame.emit(FrameEvents.LifecycleEvent, true);
    }

    private void onFrameStartedLoading(String frameId) {
        CdpFrame frame = this.frame(frameId);
        if (frame == null) {
            return;
        }
        frame.onLoadingStarted();
    }

    private void handleFrameTree(CDPSession session, FrameTreeEvent frameTree) {
        if (StringUtil.isNotEmpty(frameTree.getFrame().getParentId())) {
            this.onFrameAttached(session, frameTree.getFrame().getId(), frameTree.getFrame().getParentId());
        }
        if (!this.frameNavigatedReceived.contains(frameTree.getFrame().getId())) {
            this.onFrameNavigated(frameTree.getFrame(), "Navigation");
        } else {
            this.frameNavigatedReceived.remove(frameTree.getFrame().getId());
        }
        if (ValidateUtil.isEmpty(frameTree.getChildFrames())) {
            return;
        }
        for (FrameTreeEvent child : frameTree.getChildFrames()) {
            this.handleFrameTree(session, child);
        }
    }

    private void onFrameAttached(CDPSession session, String frameId, String parentFrameId) {
        CdpFrame frame = this.frame(frameId);
        if (frame != null) {
            if (session != null && frame.client() != this.client) {
                frame.updateClient(session);
            }
            return;
        }
        frame = new CdpFrame(this, frameId, parentFrameId, session);
        this.frameTree.addFrame(frame);
        this.emit(FrameManagerEvent.FrameAttached, frame);
    }

    private void onFrameNavigated(FramePayload framePayload, String navigationType) {
        String frameId = framePayload.getId();
        boolean isMainFrame = StringUtil.isEmpty(framePayload.getParentId());
        CdpFrame frame = this.frameTree.getById(frameId);
        if (frame != null && ValidateUtil.isNotEmpty(frame.childFrames())) {
            for (CdpFrame childFrame : frame.childFrames()) {
                this.removeFramesRecursively(childFrame);
            }
        }
        if (isMainFrame) {
            if (frame != null) {
                this.frameTree.removeFrame(frame);
                frame.setId(frameId);
            } else {
                frame = new CdpFrame(this, frameId, null, this.client);
            }
            this.frameTree.addFrame(frame);
        }
        frame = this.frameTree.waitForFrame(frameId);
        frame.navigated(framePayload);
        this.emit(FrameManagerEvent.FrameNavigated, frame);
        frame.emit(FrameEvents.FrameNavigated, navigationType);
    }

    private void createIsolatedWorld(CDPSession session, String name) {
        String key = session.id() + ":" + name;
        if (this.isolatedWorlds.contains(key)) {
            return;
        }
        this.isolatedWorlds.add(name);
        Map<String, Object> params = ParamsFactory.create();
        params.put("source", "//# sourceURL=pptr:internal");
        params.put("worldName", name);
        session.send("Page.addScriptToEvaluateOnNewDocument", params);
        this.frames().stream().filter(frame -> frame.client() == session).forEach(frame -> {
            try {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("frameId", frame.id());
                param.put("grantUniveralAccess", true);
                param.put("worldName", name);
                session.send("Page.createIsolatedWorld", param, null, false);
            }
            catch (Exception e) {
                LOGGER.error("Page.createIsolatedWorld error: ", (Throwable)e);
            }
        });
    }

    private void onFrameNavigatedWithinDocument(String frameId, String url) {
        CdpFrame frame = this.frame(frameId);
        if (Objects.isNull(frame)) {
            return;
        }
        frame.navigatedWithinDocument(url);
        this.emit(FrameManagerEvent.FrameNavigatedWithinDocument, frame);
        frame.emit(FrameEvents.FrameNavigatedWithinDocument, true);
        this.emit(FrameManagerEvent.FrameNavigated, frame);
        frame.emit(FrameEvents.FrameNavigated, "Navigation");
    }

    private void onFrameDetached(String frameId, String reason) {
        CdpFrame frame = this.frame(frameId);
        if (Objects.isNull(frame)) {
            return;
        }
        if (StringUtil.isEmpty(reason)) {
            return;
        }
        switch (reason) {
            case "remove": {
                this.removeFramesRecursively(frame);
                break;
            }
            case "swap": {
                this.emit(FrameManagerEvent.FrameSwapped, frame);
                frame.emit(FrameEvents.FrameSwapped, true);
            }
        }
    }

    private void onExecutionContextCreated(ExecutionContextDescription contextPayload, CDPSession session) {
        String frameId = contextPayload.getAuxData() != null ? contextPayload.getAuxData().getFrameId() : null;
        CdpFrame frame = this.frame(frameId);
        IsolatedWorld world = null;
        if (Objects.nonNull(frame)) {
            if (frame.client() != session) {
                return;
            }
            if (contextPayload.getAuxData() != null && contextPayload.getAuxData().getIsDefault()) {
                world = frame.worlds().get("mainWorld");
            } else if (contextPayload.getName().startsWith("__puppeteer_utility_world__3.4.0")) {
                world = frame.worlds().get("puppeteerWorld");
            }
        }
        if (Objects.isNull(world)) {
            return;
        }
        CDPSession client = Objects.nonNull(frame.client()) ? frame.client() : this.client;
        ExecutionContext context = new ExecutionContext(client, contextPayload, world);
        world.setContext(context);
    }

    private void removeFramesRecursively(CdpFrame childFrame) {
        if (ValidateUtil.isNotEmpty(childFrame.childFrames())) {
            for (CdpFrame frame : childFrame.childFrames()) {
                this.removeFramesRecursively(frame);
            }
        }
        childFrame.dispose();
        this.frameTree.removeFrame(childFrame);
        this.emit(FrameManagerEvent.FrameDetached, childFrame);
        childFrame.emit(FrameEvents.FrameDetached, childFrame);
    }

    public FrameTree<CdpFrame> frameTree() {
        return this.frameTree;
    }

    public static enum FrameManagerEvent {
        FrameAttached("FrameManager.FrameAttached"),
        FrameNavigated("FrameManager.FrameNavigated"),
        FrameDetached("FrameManager.FrameDetached"),
        FrameSwapped("FrameManager.FrameSwapped"),
        LifecycleEvent("FrameManager.LifecycleEvent"),
        FrameNavigatedWithinDocument("FrameManager.FrameNavigatedWithinDocument"),
        ConsoleApiCalled("FrameManager.ConsoleApiCalled"),
        BindingCalled("FrameManager.BindingCalled");

        private String eventName;

        private FrameManagerEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }
    }
}

