/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.events.PageEvents;
import com.ruiyun.jvppeteer.cdp.core.CdpBrowserContext;
import com.ruiyun.jvppeteer.cdp.core.CdpPage;
import com.ruiyun.jvppeteer.cdp.core.CdpTarget;
import com.ruiyun.jvppeteer.cdp.core.TargetManager;
import com.ruiyun.jvppeteer.cdp.entities.TargetInfo;
import com.ruiyun.jvppeteer.cdp.entities.TargetType;
import com.ruiyun.jvppeteer.cdp.entities.Viewport;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.transport.SessionFactory;

public class PageTarget
extends CdpTarget {
    private final Viewport defaultViewport;
    protected AwaitableResult<CdpPage> pageResult;

    public PageTarget(TargetInfo targetInfo, CDPSession session, CdpBrowserContext cdpBrowserContext, TargetManager targetManager, SessionFactory sessionFactory, Viewport defaultViewport) {
        super(targetInfo, session, cdpBrowserContext, targetManager, sessionFactory);
        this.defaultViewport = defaultViewport;
    }

    @Override
    public void initialize() {
        this.initializedCallback(CdpTarget.InitializationStatus.SUCCESS);
        this.checkIfInitialized();
    }

    @Override
    public CdpPage page() {
        if (this.pageResult == null) {
            this.pageResult = AwaitableResult.create();
            CDPSession session = this.session();
            if (session == null) {
                session = this.sessionFactory().create(false);
            }
            this.pageResult.onSuccess(CdpPage.create(session, this, this.defaultViewport));
        }
        return this.pageResult.get();
    }

    public void checkIfInitialized() {
        if (this.initializedResult.isDone()) {
            return;
        }
        if (!"".equals(this.getTargetInfo().getUrl())) {
            this.setInitializedResult(CdpTarget.InitializationStatus.SUCCESS);
        }
    }

    @Override
    public void setInitializedResult(CdpTarget.InitializationStatus status) {
        super.setInitializedResult(status);
    }

    private void initializedCallback(CdpTarget.InitializationStatus result) {
        if (CdpTarget.InitializationStatus.ABORTED.equals((Object)result)) {
            this.setInitializedResult(CdpTarget.InitializationStatus.ABORTED);
            return;
        }
        Target opener = this.opener();
        if (opener == null) {
            super.initialize();
            return;
        }
        if (!(opener instanceof PageTarget)) {
            this.setInitializedResult(CdpTarget.InitializationStatus.ABORTED);
            return;
        }
        if (((PageTarget)opener).pageResult == null || !TargetType.PAGE.equals((Object)this.type())) {
            super.initialize();
            return;
        }
        CdpPage openerPage = ((PageTarget)opener).pageResult.waitingGetResult();
        if (openerPage.listenerCount(PageEvents.Popup) == 0) {
            super.initialize();
            return;
        }
        CdpPage pupopPage = this.page();
        openerPage.emit(PageEvents.Popup, pupopPage);
        super.initialize();
    }
}

