/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing
implements Constant {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tracing.class);
    private volatile CDPSession client;
    private boolean recording;
    private String path;

    public Tracing(CDPSession client) {
        this.client = client;
        this.recording = false;
        this.path = "";
    }

    public void start(String path) {
        this.start(path, false, null);
    }

    public void start(String path, boolean screenshots, Set<String> categories) {
        ValidateUtil.assertArg(!this.recording, "Cannot start recording trace while already recording trace.");
        if (categories == null) {
            categories = new HashSet<String>(DEFAULTCATEGORIES);
        }
        if (screenshots) {
            categories.add("disabled-by-default-devtools.screenshot");
        }
        this.path = path;
        this.recording = true;
        Map<String, Object> params = ParamsFactory.create();
        params.put("transferMode", "ReturnAsStream");
        List excludedCategories = categories.stream().filter(category -> category.startsWith("-")).map(category -> category.substring(1)).collect(Collectors.toList());
        List includedCategories = categories.stream().filter(category -> !category.startsWith("-")).collect(Collectors.toList());
        Map<String, Object> catParams = ParamsFactory.create();
        catParams.put("excludedCategories", excludedCategories);
        catParams.put("includedCategories", includedCategories);
        params.put("traceConfig", catParams);
        this.client.send("Tracing.start", params);
    }

    public void stop() {
        AwaitableResult waitableResult = AwaitableResult.create();
        this.client.once(ConnectionEvents.Tracing_tracingComplete, event -> {
            try {
                ValidateUtil.assertArg(StringUtil.isNotEmpty(event.getStream()), "Missing \"stream\"");
                Helper.readProtocolStream(this.client, event.getStream(), this.path);
                waitableResult.complete();
            }
            catch (IOException e) {
                LOGGER.error("Error reading trace", (Throwable)e);
            }
        });
        this.client.send("Tracing.end");
        this.recording = false;
        waitableResult.waiting();
    }

    void updateClient(CDPSession newSession) {
        this.client = newSession;
    }
}

