/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.launch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.bidi.core.BidiBrowser;
import com.ruiyun.jvppeteer.bidi.core.BidiConnection;
import com.ruiyun.jvppeteer.cdp.core.BrowserFetcher;
import com.ruiyun.jvppeteer.cdp.core.BrowserRunner;
import com.ruiyun.jvppeteer.cdp.core.CdpBrowser;
import com.ruiyun.jvppeteer.cdp.entities.ConnectOptions;
import com.ruiyun.jvppeteer.cdp.entities.FetcherOptions;
import com.ruiyun.jvppeteer.cdp.entities.LaunchOptions;
import com.ruiyun.jvppeteer.cdp.entities.Protocol;
import com.ruiyun.jvppeteer.cdp.entities.RevisionInfo;
import com.ruiyun.jvppeteer.cdp.entities.TargetType;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.transport.CdpConnection;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransportFactory;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrowserLauncher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BrowserLauncher.class);
    protected Product product;
    protected String cacheDir;
    protected String executablePath;
    private static final Pattern WS_ENDPOINT_PATTERN = Pattern.compile("^DevTools listening on (ws://.*)$");
    private static final Pattern BiDi_ENDPOINT_PATTERN = Pattern.compile("^WebDriver BiDi listening on (ws://.*)$");

    public BrowserLauncher(String cacheDir, Product product) {
        this.cacheDir = cacheDir;
        this.product = product;
    }

    public abstract Browser launch(LaunchOptions var1) throws IOException;

    public abstract List<String> defaultArgs(LaunchOptions var1);

    public String computeExecutablePath(String preferredExecutablePath, String preferredRevision) throws IOException {
        FetcherOptions fetcherOptions = new FetcherOptions();
        fetcherOptions.setProduct(this.product);
        fetcherOptions.setCacheDir(this.cacheDir);
        BrowserFetcher browserFetcher = new BrowserFetcher(fetcherOptions);
        if (StringUtil.isNotEmpty(preferredExecutablePath)) {
            boolean assertDir = FileUtil.assertExecutable(Paths.get(preferredExecutablePath, new String[0]).normalize().toAbsolutePath().toString());
            if (!assertDir) {
                throw new IllegalArgumentException("preferredExecutablePath \"" + preferredExecutablePath + "\" is not executable");
            }
            return preferredExecutablePath;
        }
        for (int i = 0; i < Constant.EXECUTABLE_ENV.length; ++i) {
            preferredExecutablePath = System.getProperty(Constant.EXECUTABLE_ENV[i]);
            if (!StringUtil.isNotEmpty(preferredExecutablePath)) continue;
            boolean assertDir = FileUtil.assertExecutable(preferredExecutablePath);
            if (!assertDir) {
                throw new IllegalArgumentException("executablePath that in the environment is not executable");
            }
            return preferredExecutablePath;
        }
        if (StringUtil.isNotEmpty(preferredRevision)) {
            RevisionInfo revisionInfo = browserFetcher.revisionInfo(preferredRevision.replace("stable_", ""));
            if (!revisionInfo.getLocal()) {
                throw new LaunchException(MessageFormat.format("Could not find browser preferredRevision {0}. Please download a browser binary.", preferredRevision));
            }
            return revisionInfo.getExecutablePath();
        }
        String revision = System.getProperty("JVPPETEER_PRODUCT_REVISION");
        if (StringUtil.isNotEmpty(revision)) {
            revision = revision.replace("stable_", "");
        }
        if (StringUtil.isNotEmpty(revision)) {
            RevisionInfo revisionInfo = browserFetcher.revisionInfo(revision);
            if (!revisionInfo.getLocal()) {
                throw new LaunchException("Tried to use JVPPETEER_PRODUCT_REVISION_ENV env variable to launch browser but did not find executable at: " + revisionInfo.getExecutablePath());
            }
            return revisionInfo.getExecutablePath();
        }
        List<String> localRevisions = browserFetcher.localRevisions();
        if (ValidateUtil.isNotEmpty(localRevisions)) {
            localRevisions.sort(Comparator.reverseOrder());
            for (String localRevision : localRevisions) {
                RevisionInfo revisionInfo = browserFetcher.revisionInfo(localRevision);
                if (!revisionInfo.getLocal() || !StringUtil.isNotEmpty(revisionInfo.getExecutablePath()) || !FileUtil.assertExecutable(revisionInfo.getExecutablePath())) continue;
                return revisionInfo.getExecutablePath();
            }
        }
        for (int i = 0; i < Constant.PROBABLE_CHROME_EXECUTABLE_PATH.length; ++i) {
            boolean assertDir;
            preferredExecutablePath = Constant.PROBABLE_CHROME_EXECUTABLE_PATH[i];
            if (!StringUtil.isNotEmpty(preferredExecutablePath) || !(assertDir = FileUtil.assertExecutable(preferredExecutablePath))) continue;
            return preferredExecutablePath;
        }
        throw new LaunchException("Could not find anyone browser executablePath");
    }

    protected Browser createBrowser(LaunchOptions options, List<String> chromeArguments, String temporaryUserDataDir, boolean usePipe, List<String> defaultArgs, String customizedUserDataDir) {
        BrowserRunner runner = new BrowserRunner(this.executablePath, chromeArguments, temporaryUserDataDir, options.getProduct(), options.getProtocol(), customizedUserDataDir);
        try {
            if (usePipe) {
                throw new LaunchException("Not supported pipe connect to browser");
            }
            if (Protocol.CDP.equals((Object)options.getProtocol())) {
                runner.start();
                String endpoint = this.waitForWSEndpoint(options.getTimeout(), options.getDumpio(), options.getProtocol(), runner.getProcess());
                ConnectionTransport transport = WebSocketTransportFactory.create(endpoint);
                CdpConnection connection = new CdpConnection(endpoint, transport, options.getSlowMo(), options.getProtocolTimeout());
                runner.setConnection(connection);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Connect to browser by websocket url: {}", (Object)endpoint);
                }
                return this.createCdpBrowser(options, defaultArgs, runner, connection);
            }
            if (Objects.equals((Object)options.getProduct(), (Object)Product.Firefox)) {
                runner.start();
                String endpoint = this.waitForWSEndpoint(options.getTimeout(), options.getDumpio(), options.getProtocol(), runner.getProcess());
                ConnectionTransport transport = WebSocketTransportFactory.create(endpoint + "/session");
                BidiConnection connection = new BidiConnection(endpoint + "/session", transport, options.getSlowMo(), options.getProtocolTimeout());
                runner.setConnection(connection);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Connect to browser by webDriverBidi url: {}", (Object)(endpoint + "/session"));
                }
                Runnable closeCallback = runner::closeBrowser;
                return this.createBiDiBrowser(connection, closeCallback, runner.getProcess(), options);
            }
            throw new LaunchException("Chrome dont not support protocol: " + (Object)((Object)options.getProtocol()) + " yet");
        }
        catch (Exception e) {
            runner.closeBrowser();
            throw new LaunchException("Failed to launch the browser process: " + e.getMessage(), e);
        }
    }

    private String waitForWSEndpoint(int timeout, boolean dumpio, Protocol protocol, Process process) {
        return new StreamReader(timeout, dumpio, process.getInputStream(), protocol).waitFor();
    }

    private CdpBrowser createCdpBrowser(LaunchOptions options, List<String> defaultArgs, BrowserRunner runner, Connection connection) {
        Runnable closeCallback = runner::closeBrowser;
        CdpBrowser cdpBrowser = CdpBrowser.create(connection, new ArrayList<String>(), options.getAcceptInsecureCerts(), options.getDefaultViewport(), runner.getProcess(), closeCallback, options.getTargetFilter(), null, true, options.getNetworkEnabled());
        cdpBrowser.setExecutablePath(this.executablePath);
        cdpBrowser.setDefaultArgs(defaultArgs);
        if (options.getWaitForInitialPage()) {
            cdpBrowser.waitForTarget(t -> TargetType.PAGE.equals((Object)t.type()), options.getTimeout());
        }
        connection.setCloseRunner(() -> {
            if (!cdpBrowser.autoClose) {
                LOGGER.info("Websocket connection has been closed,now shutting down browser process");
                cdpBrowser.disconnect();
                try {
                    cdpBrowser.close();
                }
                catch (Exception e) {
                    LOGGER.trace("jvppeteer error", (Throwable)e);
                }
            }
        });
        runner.setPid(this.getBrowserPid(connection, runner.getProcess()));
        return cdpBrowser;
    }

    private Browser createBiDiBrowser(BidiConnection connection, Runnable closeCallback, Process process, LaunchOptions options) throws IOException {
        return BidiBrowser.create(process, closeCallback, connection, null, options.getDefaultViewport(), options.getAcceptInsecureCerts(), null, options.getNetworkEnabled());
    }

    private String getBrowserPid(Connection connection, Process process) {
        long pid = -1L;
        try {
            JsonNode response = connection.send("SystemInfo.getProcessInfo");
            Iterator processInfos = response.get("processInfo").elements();
            while (processInfos.hasNext()) {
                JsonNode processInfo = (JsonNode)processInfos.next();
                if (!processInfo.get("type").asText().equals("browser")) continue;
                pid = processInfo.get("id").asLong();
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("get browser pid error by cdp: ", (Throwable)e);
        }
        try {
            if (pid == -1L) {
                pid = Helper.getPidForLinuxOrMac(process);
            }
        }
        catch (Exception e) {
            LOGGER.error("get browser pid error by reflection: ", (Throwable)e);
        }
        return String.valueOf(pid);
    }

    public String executablePath() {
        return this.executablePath;
    }

    public Browser connect(ConnectOptions options) throws Exception {
        String endpointUrl;
        ConnectionTransport connectionTransport;
        if (options.getTransport() != null) {
            connectionTransport = options.getTransport();
            endpointUrl = "";
        } else if (StringUtil.isNotEmpty(options.getBrowserWSEndpoint())) {
            connectionTransport = WebSocketTransportFactory.create(options.getBrowserWSEndpoint(), options.getHeaders(), options.getProtocolTimeout());
            endpointUrl = options.getBrowserWSEndpoint();
        } else if (StringUtil.isNotEmpty(options.getBrowserURL())) {
            endpointUrl = this.getWSEndpoint(options.getBrowserURL());
            connectionTransport = WebSocketTransport.create(endpointUrl);
        } else {
            throw new IllegalArgumentException("Exactly one of browserWSEndpoint, browserURL or transport must be passed to puppeteer.connect");
        }
        if (Objects.equals((Object)options.getProtocol(), (Object)Protocol.WebDriverBiDi)) {
            return this.connectToBiDiBrowse(connectionTransport, endpointUrl, options);
        }
        return this.connectToCdpBrowser(connectionTransport, endpointUrl, options);
    }

    private CdpBrowser connectToCdpBrowser(ConnectionTransport connectionTransport, String url, ConnectOptions options) throws IOException {
        CdpConnection connection = new CdpConnection(url, connectionTransport, options.getSlowMo(), options.getProtocolTimeout());
        JsonNode result = connection.send("Target.getBrowserContexts");
        JavaType javaType = Constant.OBJECTMAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{String.class});
        Runnable closeCallback = () -> connection.send("Browser.close");
        List browserContextIds = (List)Constant.OBJECTMAPPER.readerFor(javaType).readValue(result.get("browserContextIds"));
        return CdpBrowser.create(connection, browserContextIds, options.getAcceptInsecureCerts(), options.getDefaultViewport(), null, closeCallback, options.getTargetFilter(), options.getIsPageTarget(), true, options.getNetworkEnabled());
    }

    private BidiBrowser connectToBiDiBrowse(ConnectionTransport connectionTransport, String url, ConnectOptions options) throws JsonProcessingException {
        block3: {
            BidiConnection pureBidiConnection = new BidiConnection(url, connectionTransport, options.getSlowMo(), options.getProtocolTimeout());
            try {
                JsonNode result = pureBidiConnection.send("session.status", Collections.emptyMap());
                if (result.has("type") && Objects.equals(result.get("type").asText(), "success")) {
                    return BidiBrowser.create(null, null, pureBidiConnection, null, options.getDefaultViewport(), options.getAcceptInsecureCerts(), options.getCapabilities(), options.getNetworkEnabled());
                }
            }
            catch (Exception e) {
                if (e instanceof ProtocolException) break block3;
                throw e;
            }
        }
        throw new JvppeteerException("Fail to connect Browser by options " + options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWSEndpoint(String browserURL) throws IOException {
        JsonNode jsonNode;
        URI uri = URI.create(browserURL).resolve("/json/version");
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod("GET");
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new JvppeteerException("browserURL: " + browserURL + ",HTTP " + responseCode);
            }
            String result = StreamUtil.toString(conn.getInputStream());
            jsonNode = Constant.OBJECTMAPPER.readTree(result);
        }
        finally {
            conn.disconnect();
        }
        return jsonNode.get("webSocketDebuggerUrl").asText();
    }

    static /* synthetic */ Pattern access$000() {
        return BiDi_ENDPOINT_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return WS_ENDPOINT_PATTERN;
    }

    static class StreamReader {
        private final StringBuilder chromeOutputBuilder = new StringBuilder();
        private volatile String wsEndpoint = null;
        private final int timeout;
        private final boolean dumpio;
        private final InputStream inputStream;
        private final Protocol protocol;

        public StreamReader(int timeout, boolean dumpio, InputStream inputStream, Protocol protocol) {
            this.timeout = timeout;
            this.dumpio = dumpio;
            this.inputStream = inputStream;
            this.protocol = protocol;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String waitFor() {
            try {
                inputStreamReader = new InputStreamReader(this.inputStream);
                var2_3 = null;
                try {
                    reader = new BufferedReader(inputStreamReader);
                    var4_6 = null;
                    now = System.currentTimeMillis();
                    base = 0L;
lbl10:
                    // 2 sources

                    while (true) {
                        line = reader.readLine();
                        if (line == null) throw new LaunchException("Failed to launch the browser process! Browser process Output: " + this.chromeOutputBuilder);
                        remaining = (long)this.timeout - base;
                        if (remaining <= 0L) {
                            throw new TimeoutException("Failed to launch the browser process!Chrome output: " + this.chromeOutputBuilder);
                        }
                        if (this.dumpio) {
                            System.out.println(line);
                        }
                        v0 = matcher = Objects.equals((Object)Protocol.WebDriverBiDi, (Object)this.protocol) != false ? BrowserLauncher.access$000().matcher(line) : BrowserLauncher.access$100().matcher(line);
                        if (!matcher.find()) ** GOTO lbl47
                        var13_13 = this.wsEndpoint = matcher.group(1);
                        if (reader == null) return var13_13;
                        if (var4_6 != null) {
                        }
                        ** GOTO lbl45
                        break;
                    }
                    {
                        catch (Throwable var5_8) {
                            var4_6 = var5_8;
                            throw var5_8;
                        }
                        catch (Throwable var15_16) {
                            if (reader == null) throw var15_16;
                            if (var4_6 == null) {
                                reader.close();
                                throw var15_16;
                            }
                            try {
                                reader.close();
                                throw var15_16;
                            }
                            catch (Throwable var16_17) {
                                var4_6.addSuppressed(var16_17);
                                throw var15_16;
                            }
                        }
                        try {
                            reader.close();
                            return var13_13;
                        }
                        catch (Throwable var14_14) {
                            var4_6.addSuppressed(var14_14);
                            return var13_13;
                        }
lbl45:
                        // 1 sources

                        reader.close();
                        return var13_13;
lbl47:
                        // 1 sources

                        ** try [egrp 6[TRYBLOCK] [8 : 229->332)] { 
lbl-1000:
                        // 1 sources

                        {
                            this.chromeOutputBuilder.append(line).append(System.lineSeparator());
                            base = System.currentTimeMillis() - now;
                            ** continue;
                        }
                    }
                }
lbl52:
                // 2 sources

                catch (Throwable var3_5) {
                    var2_3 = var3_5;
                    throw var3_5;
                }
                finally {
                    if (inputStreamReader != null) {
                        if (var2_3 != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Throwable var14_15) {
                                var2_3.addSuppressed(var14_15);
                            }
                        } else {
                            inputStreamReader.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new LaunchException("Failed to launch the browser process! " + e.getMessage() + "Chrome process Output: " + this.chromeOutputBuilder, e);
            }
        }
    }
}

