/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.concurrent.TimeUnit;

public class Callback {
    private final long id;
    private String errorMsg = null;
    public final String label;
    private final int timeout;
    final AwaitableResult<JsonNode> waitingResponse = AwaitableResult.create();
    private int code;

    public Callback(long id, String label, int timeout) {
        this.id = id;
        this.label = label;
        this.timeout = timeout;
    }

    public void resolve(JsonNode value) {
        this.waitingResponse.onSuccess(value);
    }

    public void reject() {
        this.waitingResponse.complete();
    }

    public void reject(String errorMsg, int code) {
        this.waitingResponse.complete();
        this.errorMsg = errorMsg;
        this.code = code;
    }

    public long id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public JsonNode waitForResponse() throws InterruptedException {
        boolean waiting = this.waitingResponse.waiting(this.timeout, TimeUnit.MILLISECONDS);
        if (!waiting) {
            throw new TimeoutException("Timeout waiting for response for " + this.label);
        }
        if (StringUtil.isNotEmpty(this.errorMsg)) {
            throw new ProtocolException(this.errorMsg, this.code);
        }
        return this.waitingResponse.get();
    }

    public String errorMsg() {
        return this.errorMsg;
    }
}

