/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.cdp.core.CdpTarget;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CallbackRegistry;
import com.ruiyun.jvppeteer.transport.CdpConnection;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpCDPSession
extends CDPSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdpCDPSession.class);
    private final String targetType;
    private final String sessionId;
    private final CdpConnection connection;
    private final String parentSessionId;
    private CdpTarget target;
    private volatile boolean detached;

    public CdpCDPSession(CdpConnection connection, String targetType, String sessionId, String parentSessionId) {
        this.targetType = targetType;
        this.sessionId = sessionId;
        this.connection = connection;
        this.parentSessionId = parentSessionId;
    }

    @Override
    public CDPSession parentSession() {
        if (StringUtil.isEmpty(this.parentSessionId)) {
            return this;
        }
        if (Objects.nonNull(this.connection)) {
            return this.connection.session(this.parentSessionId);
        }
        return null;
    }

    public void setTarget(CdpTarget target) {
        this.target = target;
    }

    @Override
    public void onClosed() {
        this.detached = true;
        this.emit(ConnectionEvents.CDPSession_Disconnected, true);
    }

    @Override
    public JsonNode send(String method) {
        return this.send(method, null);
    }

    public JsonNode send(String method, Map<String, Object> params) {
        return this.send(method, params, null, true);
    }

    @Override
    public JsonNode send(String method, Object params, Integer timeout, boolean isBlocking) {
        if (this.detached()) {
            throw new JvppeteerException("Protocol error (" + method + "): Session closed. Most likely the" + this.targetType + "has been closed.");
        }
        return this.connection.rawSend(method, params, this.sessionId, timeout, isBlocking);
    }

    @Override
    public void detach() {
        if (this.detached()) {
            throw new JvppeteerException("Session already detached. Most likely the " + this.targetType + "has been closed.");
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("sessionId", this.sessionId);
        this.connection.send("Target.detachFromTarget", params);
        this.detached = true;
    }

    public void onMessage(JsonNode response, CallbackRegistry callbacks) {
        JsonNode paramsNode = response.get("params");
        JsonNode methodNode = response.get("method");
        try {
            if (response.hasNonNull("id")) {
                long id = response.get("id").asLong();
                CdpConnection.handleCdpCallback(callbacks, response, id, false);
            } else {
                ValidateUtil.assertArg(!response.hasNonNull("id"), "Should not contain id, " + response);
                if (Objects.isNull(this.connection)) {
                    return;
                }
                String method = methodNode.asText();
                boolean match = Constant.EVENTS.contains(method);
                if (match) {
                    this.emit(ConnectionEvents.valueOf(method.replace(".", "_")), Constant.LISTENER_CLASSES.get(method) == null ? Boolean.valueOf(true) : Constant.OBJECTMAPPER.treeToValue((TreeNode)paramsNode, Constant.LISTENER_CLASSES.get(method)));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("emit error", (Throwable)e);
        }
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public boolean detached() {
        return this.connection.closed() || this.detached;
    }

    @Override
    public String id() {
        return this.sessionId;
    }

    public CdpTarget getTarget() {
        Objects.requireNonNull(this.target, "Target must exist");
        return this.target;
    }
}

