/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransportFactory;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketClient
implements ConnectionTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketTransport.class);
    private Connection connection = null;

    public WebSocketTransport(URI serverUri, Draft protocolDraft, Map<String, String> httpHeaders, int timeout) {
        super(serverUri, protocolDraft, httpHeaders, timeout);
    }

    public static ConnectionTransport create(String browserWSEndpoint) throws Exception {
        return WebSocketTransportFactory.create(browserWSEndpoint);
    }

    @Override
    public void onMessage(String message) {
        Objects.requireNonNull(this.connection, "Connection may be closed!");
        this.connection.onMessage(message);
    }

    public void onClose(int code, String reason, boolean remote) {
        LOGGER.info("Websocket connection closed by {} Code: {} Reason: {}", new Object[]{remote ? "remote peer" : "us", code, StringUtil.isEmpty(reason) ? Constant.CLOSE_REASON.get(code) : reason});
        Optional.ofNullable(this.connection).map(Connection::closeRunner).ifPresent(Runnable::run);
    }

    public void onError(Exception e) {
        LOGGER.error("Websocket error:", (Throwable)e);
    }

    public void onOpen(ServerHandshake serverHandshake) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Websocket serverHandshake status: {}", (Object)serverHandshake.getHttpStatusMessage());
        }
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void onWebsocketPong(WebSocket conn, Framedata f) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Websocket connection receive pong response: {}", (Object)f);
        }
    }
}

