/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;

public class WebSocketTransportFactory
implements Constant {
    public static ConnectionTransport create(String url) throws Exception {
        return WebSocketTransportFactory.create(url, null, 30000);
    }

    public static ConnectionTransport create(String url, Map<String, String> httpHeaders, int timeout) throws Exception {
        WebSocketTransport client;
        boolean connected;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", "Puppeteer 3.4.0");
        if (Objects.nonNull(httpHeaders)) {
            headers.putAll(httpHeaders);
        }
        if (!(connected = (client = new WebSocketTransport(URI.create(url), (Draft)new Draft_6455(), headers, timeout)).connectBlocking(timeout, TimeUnit.MILLISECONDS))) {
            throw new LaunchException("Websocket connection was not successful, please check if the URL(" + url + ") is effective.");
        }
        return client;
    }
}

