/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.util;

import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.Helper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;

public class FileUtil {
    static Set<PosixFilePermission> rwxrwxrwx = PosixFilePermissions.fromString("rwxrwxrwx");

    public static String createProfileDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (Exception e) {
            throw new JvppeteerException("Create temp profile dir fail:", e);
        }
    }

    public static boolean assertExecutable(String executablePath) {
        Path path = Paths.get(executablePath, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path) && Files.isExecutable(path);
    }

    public static void removeFolderOnExit(String path) throws IOException {
        Path userDirPath = Paths.get(path, new String[0]);
        if (Files.exists(userDirPath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(userDirPath, new FileVisitOption[0]);){
                paths.map(Path::toFile).forEach(file -> {
                    if (file.exists()) {
                        file.deleteOnExit();
                    }
                });
            }
            userDirPath.toFile().deleteOnExit();
        }
    }

    public static void removeFolder(String path) throws IOException {
        Path userDirPath = Paths.get(path, new String[0]);
        if (Files.exists(userDirPath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(userDirPath, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> {
                    if (file.exists()) {
                        file.delete();
                    }
                });
            }
        }
    }

    public static void createNewFile(String path) throws IOException {
        Path path1 = Paths.get(path, new String[0]);
        if (!Files.exists(path1, new LinkOption[0])) {
            Path parent = path1.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                FileUtil.createDirs(parent);
            }
            if (Helper.isMac() || Helper.isLinux()) {
                Files.createFile(path1, PosixFilePermissions.asFileAttribute(rwxrwxrwx));
            } else if (Helper.isWindows()) {
                Files.createFile(path1, new FileAttribute[0]);
            }
        }
    }

    public static void createDirs(Path path) throws IOException {
        if (Helper.isMac() || Helper.isLinux()) {
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(rwxrwxrwx));
        } else if (Helper.isWindows()) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }
}

