/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.bidi.entities.SameSite;
import com.ruiyun.jvppeteer.cdp.entities.CallFrame;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookiePriority;
import com.ruiyun.jvppeteer.cdp.entities.CookieSameSite;
import com.ruiyun.jvppeteer.cdp.entities.CookieSourceScheme;
import com.ruiyun.jvppeteer.cdp.entities.ExceptionDetails;
import com.ruiyun.jvppeteer.cdp.entities.GetVersionResponse;
import com.ruiyun.jvppeteer.cdp.entities.RemoteObject;
import com.ruiyun.jvppeteer.cdp.entities.StackTrace;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Helper.class);

    public static Object createClientError(ExceptionDetails exceptionDetails) {
        String message;
        String name = "";
        if (exceptionDetails.getException() == null) {
            name = "Error";
            message = exceptionDetails.getText();
        } else {
            if (!"object".equals(exceptionDetails.getException().getType()) || !"error".equals(exceptionDetails.getException().getSubtype()) && StringUtil.isEmpty(exceptionDetails.getException().getObjectId())) {
                return Helper.valueFromRemoteObject(exceptionDetails.getException());
            }
            CharSequence[] lines = Optional.of(exceptionDetails).map(ExceptionDetails::getException).map(RemoteObject::getDescription).orElse("").split("\\n {4}at ");
            int size = Math.min(Optional.of(exceptionDetails).map(ExceptionDetails::getStackTrace).map(StackTrace::getCallFrames).map(List::size).orElse(0), lines.length - 1);
            lines = (String[])Arrays.stream(lines).limit(lines.length - size).toArray(String[]::new);
            String className = Optional.of(exceptionDetails).map(ExceptionDetails::getException).map(RemoteObject::getClassName).orElse("");
            if (StringUtil.isNotEmpty(className)) {
                name = className;
            }
            message = String.join((CharSequence)"\n", lines);
            if (StringUtil.isNotEmpty(name) && message.startsWith(name + ":")) {
                message = message.substring(name.length() + 2);
            }
        }
        EvaluateException error = new EvaluateException(message);
        error.setName(name);
        int messageHeight = message.split("\n").length;
        String stack = error.getStack();
        List<Object> messageLines = new ArrayList();
        if (StringUtil.isNotEmpty(stack)) {
            messageLines = new ArrayList<String>(Arrays.asList(stack.split("\n"))).subList(0, messageHeight);
        }
        ArrayList<String> stackLines = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (exceptionDetails.getStackTrace() != null) {
            for (CallFrame callframe : exceptionDetails.getStackTrace().getCallFrames()) {
                String location = callframe.getUrl() + ":" + (callframe.getLineNumber() + 1) + ":" + (callframe.getColumnNumber() + 1);
                String functionName = StringUtil.isNotEmpty(callframe.getFunctionName()) ? callframe.getFunctionName() : "<anonymous>";
                stringBuilder.append("\n    at ").append(functionName).append("(").append(location).append(")");
                stackLines.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        messageLines.addAll(stackLines);
        error.setStack(String.join((CharSequence)"\n", messageLines));
        return error;
    }

    public static Object createCdpEvaluationError(ExceptionDetails exceptionDetails) {
        String message;
        String name = "";
        if (exceptionDetails.getException() == null) {
            name = "Error";
            message = exceptionDetails.getText();
        } else {
            if (!"object".equals(exceptionDetails.getException().getType()) || !"error".equals(exceptionDetails.getException().getSubtype()) && StringUtil.isEmpty(exceptionDetails.getException().getObjectId())) {
                return Helper.valueFromRemoteObject(exceptionDetails.getException());
            }
            CharSequence[] lines = Optional.of(exceptionDetails).map(ExceptionDetails::getException).map(RemoteObject::getDescription).orElse("").split("\n {4}at ");
            int size = Math.min(Optional.of(exceptionDetails).map(ExceptionDetails::getStackTrace).map(StackTrace::getCallFrames).map(List::size).orElse(0), lines.length - 1);
            lines = (String[])Arrays.stream(lines).limit(lines.length - size).toArray(String[]::new);
            String className = (String)Optional.of(exceptionDetails).flatMap(details -> Optional.of(details.getException().getClassName())).get();
            if (StringUtil.isNotEmpty(className)) {
                name = className;
            }
            message = String.join((CharSequence)"\n", lines);
            if (StringUtil.isNotEmpty(name) && message.startsWith(name + ": ")) {
                message = message.substring(name.length() + 2);
            }
        }
        int messageHeight = message.split("\n").length;
        LinkedList<String> stackLines = new LinkedList<String>();
        List<String> messageLines = new ArrayList();
        if (ValidateUtil.isNotEmpty(stackLines)) {
            messageLines = stackLines.subList(0, messageHeight);
        }
        stackLines.poll();
        StringBuilder stringBuilder = new StringBuilder();
        if (exceptionDetails.getStackTrace() != null) {
            int i = exceptionDetails.getStackTrace().getCallFrames().size();
            while (i-- > 0) {
                CallFrame callFrame = exceptionDetails.getStackTrace().getCallFrames().get(i);
                if (Helper.isPuppeteerURL(callFrame.getUrl()) && !"pptr:internal".equals(callFrame.getUrl())) {
                    PuppeteerURL url = Helper.parse(callFrame.getUrl());
                    try {
                        stringBuilder.append("\n    jvppeteer print: at ").append(URLDecoder.decode(url.getSiteString(), StandardCharsets.UTF_8.name()));
                    }
                    catch (UnsupportedEncodingException e) {
                        stringBuilder.append(url.getSiteString()).append(", <anonymous>:").append(callFrame.getLineNumber()).append(":").append(callFrame.getColumnNumber());
                    }
                    stackLines.addFirst(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                String functionName = StringUtil.isNotEmpty(callFrame.getFunctionName()) ? callFrame.getFunctionName() : "<anonymous>";
                stringBuilder.append("\n    at ").append(functionName).append("(").append(callFrame.getUrl()).append(":").append(callFrame.getLineNumber()).append(":").append(callFrame.getColumnNumber());
                stackLines.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        messageLines.addAll(stackLines);
        EvaluateException error = new EvaluateException(name + " : " + message + String.join((CharSequence)"\n", messageLines));
        error.setName(name);
        return error;
    }

    public static void createBidiEvaluationError(com.ruiyun.jvppeteer.bidi.entities.ExceptionDetails details) {
        if (!Objects.equals("error", details.getException().getType())) {
            throw new EvaluateException(String.valueOf(details.getException().getValue()));
        }
        String[] parts = details.getText().split(": ", 2);
        String name = parts.length > 0 ? parts[0] : "";
        String message = parts.length > 1 ? String.join((CharSequence)": ", Arrays.copyOfRange(parts, 1, parts.length)) : "";
        LinkedList<String> stackLines = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (details.getStackTrace() != null) {
            int i = details.getStackTrace().getCallFrames().size();
            while (i-- > 0) {
                CallFrame callFrame = details.getStackTrace().getCallFrames().get(i);
                if (Helper.isPuppeteerURL(callFrame.getUrl()) && !"pptr:internal".equals(callFrame.getUrl())) {
                    PuppeteerURL url = Helper.parse(callFrame.getUrl());
                    try {
                        stringBuilder.append("\n    jvppeteer print: at ").append(URLDecoder.decode(url.getSiteString(), StandardCharsets.UTF_8.name()));
                    }
                    catch (UnsupportedEncodingException e) {
                        stringBuilder.append(url.getSiteString()).append(", <anonymous>:").append(callFrame.getLineNumber()).append(":").append(callFrame.getColumnNumber());
                    }
                    stackLines.addFirst(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                String functionName = StringUtil.isNotEmpty(callFrame.getFunctionName()) ? callFrame.getFunctionName() : "<anonymous>";
                stringBuilder.append("\n    at ").append(functionName).append("(").append(callFrame.getUrl()).append(":").append(callFrame.getLineNumber()).append(":").append(callFrame.getColumnNumber());
                stackLines.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        throw new EvaluateException("name: " + name + ", text: " + details.getText() + ", message: " + message + String.join((CharSequence)"\n", stackLines));
    }

    public static PuppeteerURL parse(String url) {
        String[] split = (url = url.substring("pptr:".length())).split(";");
        if (split.length == 2) {
            PuppeteerURL puppeteerURL = new PuppeteerURL();
            try {
                puppeteerURL.setSiteString(URLDecoder.decode(split[1], StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new JvppeteerException(e);
            }
            puppeteerURL.setFunctionName(split[0]);
            return puppeteerURL;
        }
        return new PuppeteerURL();
    }

    public static String withSourcePuppeteerURLIfNone(String functionName, String pptrFunction) {
        if (Constant.SOURCE_URL_REGEX.matcher(pptrFunction).find()) {
            return pptrFunction;
        }
        ArrayList<String> args = new ArrayList<String>();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        args.add(functionName);
        try {
            args.add(URLEncoder.encode(stackTraceElements[3].toString(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            args.add("ModuleJob.run%20(node%3Ainternal%2Fmodules%2Fesm%2Fmodule_job%3A222%3A25)");
        }
        return pptrFunction + "\n//# sourceURL=pptr:" + String.join((CharSequence)";", args) + "\n";
    }

    public static String platform() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String arch() {
        return System.getProperty("os.arch").toLowerCase();
    }

    public static boolean isWindows() {
        return Helper.platform().contains("win");
    }

    public static boolean is64() {
        return Helper.arch().contains("64");
    }

    public static boolean isLinux() {
        return Helper.platform().contains("linux");
    }

    public static boolean isMac() {
        return Helper.platform().contains("mac");
    }

    public static String join(String root, String ... args) {
        return Paths.get(root, args).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readProtocolStream(CDPSession client, String handler, String path) throws IOException {
        byte[] byArray;
        boolean eof = false;
        File file = null;
        BufferedOutputStream writer = null;
        BufferedInputStream reader = null;
        if (StringUtil.isNotEmpty(path)) {
            file = new File(path);
            FileUtil.createNewFile(path);
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("handle", handler);
        try {
            if (file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                writer = new BufferedOutputStream(fileOutputStream);
            }
            byte[] buffer = new byte[8192];
            ArrayList<byte[]> bufs = new ArrayList<byte[]>();
            int byteLength = 0;
            while (!eof) {
                String dataText;
                JsonNode response = client.send("IO.read", params);
                JsonNode eofNode = response.get("eof");
                JsonNode base64EncodedNode = response.get("base64Encoded");
                JsonNode dataNode = response.get("data");
                if (dataNode != null && StringUtil.isNotEmpty(dataText = dataNode.asText())) {
                    try {
                        byte[] bytes = base64EncodedNode != null && base64EncodedNode.asBoolean() ? Base64.getDecoder().decode(dataText) : dataNode.asText().getBytes();
                        bufs.add(bytes);
                        byteLength += bytes.length;
                        if (file != null) {
                            int read;
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                            reader = new BufferedInputStream(byteArrayInputStream);
                            while ((read = reader.read(buffer, 0, 8192)) != -1) {
                                writer.write(buffer, 0, read);
                                writer.flush();
                            }
                        }
                    }
                    finally {
                        StreamUtil.closeQuietly(reader);
                    }
                }
                eof = eofNode == null || eofNode.asBoolean();
            }
            client.send("IO.close", params);
            byArray = Helper.getBytes(bufs, byteLength);
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(writer);
            StreamUtil.closeQuietly(reader);
            throw throwable;
        }
        StreamUtil.closeQuietly(writer);
        StreamUtil.closeQuietly(reader);
        return byArray;
    }

    private static byte[] getBytes(List<byte[]> bufs, int byteLength) {
        byte[] resultBuf = new byte[byteLength];
        int destPos = 0;
        for (byte[] buf : bufs) {
            System.arraycopy(buf, 0, resultBuf, destPos, buf.length);
            destPos += buf.length;
        }
        return resultBuf;
    }

    public static boolean isNumber(String s) {
        Pattern pattern = Pattern.compile("-?[0-9]+(\\.[0-9]+)?");
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public static Object valueFromRemoteObject(RemoteObject remoteObject) {
        ValidateUtil.assertArg(StringUtil.isEmpty(remoteObject.getObjectId()), "Cannot extract value when objectId is given");
        if (StringUtil.isNotEmpty(remoteObject.getUnserializableValue())) {
            if ("bigint".equals(remoteObject.getType())) {
                return new BigInteger(remoteObject.getUnserializableValue().replace("n", ""));
            }
            switch (remoteObject.getUnserializableValue()) {
                case "-0": 
                case "NaN": 
                case "Infinity": 
                case "-Infinity": {
                    return remoteObject.getUnserializableValue();
                }
            }
            throw new JvppeteerException("Unsupported unserializable value: " + remoteObject.getUnserializableValue());
        }
        return remoteObject.getValue();
    }

    public static void releaseObject(CDPSession client, RemoteObject remoteObject) {
        if (StringUtil.isEmpty(remoteObject.getObjectId())) {
            return;
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("objectId", remoteObject.getObjectId());
        try {
            client.send("Runtime.releaseObject", params, null, false);
        }
        catch (Exception e) {
            LOGGER.error("jvppeteer error: ", (Throwable)e);
        }
    }

    public static String evaluationString(String fun, Object ... args) throws JsonProcessingException {
        if (!Helper.isFunction(fun)) {
            ValidateUtil.assertArg(args.length == 0, "Cannot evaluate a string with arguments");
            return fun;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        for (Object arg : args) {
            if (arg == null) {
                argsList.add("undefined");
                continue;
            }
            argsList.add(Constant.OBJECTMAPPER.writeValueAsString(arg));
        }
        return MessageFormat.format("({0})({1})", fun, String.join((CharSequence)",", argsList));
    }

    public static boolean isFunction(String pptrFunction) {
        return (pptrFunction = pptrFunction.trim()).startsWith("function") || pptrFunction.startsWith("async") || pptrFunction.contains("=>");
    }

    public static long getPidForLinuxOrMac(Process process) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        long pid = -1L;
        if (Helper.isMac() || Helper.isLinux()) {
            String version = System.getProperty("java.version");
            double jdkVersion = Double.parseDouble(version.substring(0, 3));
            Class<?> clazz = jdkVersion <= 1.8 ? Class.forName("java.lang.UNIXProcess") : Class.forName("java.lang.ProcessImpl");
            Field field = clazz.getDeclaredField("pid");
            field.setAccessible(true);
            pid = ((Integer)field.get(process)).intValue();
        }
        return pid;
    }

    public static String createProtocolErrorMessage(JsonNode receivedNode) {
        String message = receivedNode.get("error").get("message").asText();
        if (receivedNode.get("error").hasNonNull("data")) {
            message = message + " " + receivedNode.get("error").get("data").asText();
        }
        return message;
    }

    public static <T> T waitForCondition(Supplier<T> conditionChecker, long timeout, String errorMessage) {
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        long checkInterval = 100L;
        long maxInterval = 2000L;
        T result;
        while ((result = conditionChecker.get()) == null) {
            elapsedTime = System.currentTimeMillis() - startTime;
            long remaining = timeout - elapsedTime;
            if (timeout > 0L && remaining <= 0L) {
                throw new TimeoutException(errorMessage);
            }
            Helper.justWait(Math.min(checkInterval, remaining));
            checkInterval = Math.min(checkInterval * 2L, maxInterval);
        }
        return result;
    }

    public static void justWait(long timeout) {
        CountDownLatch latch = new CountDownLatch(1);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new JvppeteerException(e);
        }
    }

    public static <T> T filter(List<T> targets, Predicate<T> predicate) {
        if (ValidateUtil.isNotEmpty(targets)) {
            for (T target : targets) {
                if (!predicate.test(target)) continue;
                return target;
            }
        }
        return null;
    }

    public static boolean isPuppeteerURL(String url) {
        return url.startsWith("pptr:");
    }

    public static void throwError(Throwable error) {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new JvppeteerException(error);
    }

    public static GetVersionResponse getVersion(Connection connection) {
        return (GetVersionResponse)Constant.OBJECTMAPPER.convertValue((Object)connection.send("Browser.getVersion"), GetVersionResponse.class);
    }

    public static void rewriteNavigationError(String message, int timeout, Exception error) {
        if (error instanceof ProtocolException) {
            String newMessage = error.getMessage() + "    at  " + message;
            throw new ProtocolException(newMessage, error);
        }
        if (error instanceof TimeoutException) {
            String newMessage = "Navigation timeout of " + timeout + " ms exceeded";
            throw new TimeoutException(newMessage, error);
        }
        Helper.throwError(error);
    }

    public static String setSourceUrlComment(String pptrFunction) {
        if (Constant.SOURCE_URL_REGEX.matcher(pptrFunction).find()) {
            return pptrFunction;
        }
        return pptrFunction + "\n//# sourceURL=" + "pptr:internal" + "\n";
    }

    public static ObjectNode convertCookiesPartitionKeyFromPuppeteerToCdp(JsonNode partitionKey) {
        if (Objects.isNull(partitionKey)) {
            return null;
        }
        ObjectNode objectNode = Constant.OBJECTMAPPER.createObjectNode();
        if (partitionKey.isTextual()) {
            objectNode.put("topLevelSite", partitionKey.asText());
            objectNode.put("hasCrossSiteAncestor", false);
        } else {
            objectNode.set("topLevelSite", partitionKey.get("sourceOrigin"));
            objectNode.put("hasCrossSiteAncestor", !partitionKey.path("hasCrossSiteAncestor").isMissingNode() && partitionKey.path("hasCrossSiteAncestor").asBoolean());
        }
        return objectNode;
    }

    public static Cookie bidiToPuppeteerCookie(JsonNode bidiCookie) {
        JsonNode partitionKey;
        JsonNode priority;
        JsonNode partitionKeyOpaque;
        JsonNode sourceScheme;
        Cookie cookie = new Cookie();
        cookie.setName(bidiCookie.path("name").asText());
        cookie.setValue(bidiCookie.at("/value/value").asText());
        cookie.setDomain(bidiCookie.get("domain").asText());
        cookie.setPath(bidiCookie.get("path").asText());
        cookie.setSize(bidiCookie.get("size").asInt());
        cookie.setHttpOnly(bidiCookie.get("httpOnly").asBoolean());
        cookie.setSecure(bidiCookie.get("secure").asBoolean());
        cookie.setSameSite(Helper.convertCookiesSameSiteBiDiToCdp(bidiCookie.get("sameSite")));
        JsonNode expires = bidiCookie.path("expires");
        cookie.setExpires(expires.isMissingNode() ? -1L : (long)expires.asInt());
        cookie.setSession(expires.isMissingNode() || expires.asInt() <= 0);
        JsonNode sameParty = bidiCookie.path("goog:sameParty");
        if (!sameParty.isMissingNode()) {
            cookie.setSameParty(sameParty.asBoolean());
        }
        if (!(sourceScheme = bidiCookie.path("goog:sourceScheme")).isMissingNode()) {
            cookie.setSourceScheme(CookieSourceScheme.valueOf(sourceScheme.asText()));
        }
        if (!(partitionKeyOpaque = bidiCookie.path("goog:partitionKeyOpaque")).isMissingNode()) {
            cookie.setPartitionKeyOpaque(partitionKeyOpaque.asBoolean());
        }
        if (!(priority = bidiCookie.path("goog:priority")).isMissingNode()) {
            cookie.setPriority(CookiePriority.valueOf(partitionKeyOpaque.asText()));
        }
        if (!(partitionKey = bidiCookie.path("goog:partitionKey")).isMissingNode()) {
            if (partitionKey.isTextual()) {
                cookie.setPartitionKey(partitionKey);
            } else if (partitionKey.isObject()) {
                ObjectNode partitionKeyNode = Constant.OBJECTMAPPER.createObjectNode();
                partitionKeyNode.set("partitionKey", partitionKey.get("topLevelSite"));
                cookie.setPartitionKey((JsonNode)partitionKeyNode);
            }
        }
        return cookie;
    }

    public static CookieSameSite convertCookiesSameSiteBiDiToCdp(JsonNode sameSite) {
        return Objects.equals("strict", sameSite.asText()) ? CookieSameSite.Strict : (Objects.equals("lax", sameSite.asText()) ? CookieSameSite.Lax : CookieSameSite.None);
    }

    public static SameSite convertCookiesSameSiteCdpToBiDi(CookieSameSite sameSite) {
        return Objects.equals((Object)sameSite, (Object)CookieSameSite.Strict) ? SameSite.Strict : (Objects.equals((Object)sameSite, (Object)CookieSameSite.Lax) ? SameSite.Lax : SameSite.None);
    }

    public static String convertCookiesPartitionKeyFromPuppeteerToBiDi(JsonNode partitionKey) {
        if (Objects.isNull(partitionKey)) {
            return null;
        }
        if (partitionKey.isTextual()) {
            return partitionKey.asText();
        }
        if (!partitionKey.path("hasCrossSiteAncestor").isMissingNode()) {
            throw new UnsupportedOperationException("WebDriver BiDi does not support `hasCrossSiteAncestor` yet.");
        }
        return partitionKey.get("sourceOrigin").asText();
    }

    public static void removeNull(Object params) {
        if (params instanceof Map) {
            Map map = (Map)params;
            map.entrySet().removeIf(entry -> {
                if (entry.getValue() == null) {
                    return true;
                }
                if (entry.getValue() instanceof Map) {
                    Helper.removeNull(entry.getValue());
                }
                return false;
            });
        }
    }

    public static class PuppeteerURL {
        private String siteString;
        private String functionName;

        public String getSiteString() {
            return this.siteString;
        }

        public void setSiteString(String siteString) {
            this.siteString = siteString;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }
    }
}

