/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.core;

import io.github.fastily.jwiki.core.Wiki;
import io.github.fastily.jwiki.util.FL;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class ApiClient {
    private static final MediaType octetstream = MediaType.parse((String)"application/octet-stream");
    protected final OkHttpClient client;
    private Wiki wiki;

    protected ApiClient(Wiki wiki, Proxy proxy) {
        this.wiki = wiki;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)new JwikiCookieJar()).readTimeout(2L, TimeUnit.MINUTES);
        if (proxy != null) {
            builder.proxy(proxy);
        }
        this.client = builder.build();
    }

    protected ApiClient(Wiki from, Wiki to) {
        this.wiki = to;
        this.client = from.apiclient.client;
        JwikiCookieJar cl = (JwikiCookieJar)this.client.cookieJar();
        HashMap l = new HashMap();
        cl.cj.get(from.conf.hostname).forEach((k, v) -> {
            if (k.contains("centralauth")) {
                l.put(k, v);
            }
        });
        cl.cj.put(this.wiki.conf.hostname, l);
    }

    private Request.Builder startReq(HashMap<String, String> params) {
        HttpUrl.Builder hb = this.wiki.conf.baseURL.newBuilder();
        params.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)hb).addQueryParameter(arg_0, arg_1));
        return new Request.Builder().url(hb.build()).header("User-Agent", this.wiki.conf.userAgent);
    }

    protected Response basicGET(HashMap<String, String> params) throws IOException {
        return this.client.newCall(this.startReq(params).get().build()).execute();
    }

    protected Response basicPOST(HashMap<String, String> params, HashMap<String, String> form) throws IOException {
        FormBody.Builder fb = new FormBody.Builder();
        form.forEach((arg_0, arg_1) -> ((FormBody.Builder)fb).add(arg_0, arg_1));
        return this.client.newCall(this.startReq(params).post((RequestBody)fb.build()).build()).execute();
    }

    protected Response multiPartFilePOST(HashMap<String, String> params, HashMap<String, String> form, String fn, byte[] chunk) throws IOException {
        MultipartBody.Builder mpb = new MultipartBody.Builder().setType(MultipartBody.FORM);
        form.forEach((arg_0, arg_1) -> ((MultipartBody.Builder)mpb).addFormDataPart(arg_0, arg_1));
        mpb.addFormDataPart("chunk", fn, RequestBody.create((byte[])chunk, (MediaType)octetstream));
        Request r = this.startReq(params).post((RequestBody)mpb.build()).build();
        return this.client.newCall(r).execute();
    }

    private static class JwikiCookieJar
    implements CookieJar {
        private HashMap<String, HashMap<String, String>> cj = new HashMap();

        private JwikiCookieJar() {
        }

        public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
            String host = url.host();
            if (!this.cj.containsKey(host)) {
                this.cj.put(host, new HashMap());
            }
            HashMap<String, String> m = this.cj.get(host);
            for (Cookie c : cookies) {
                m.put(c.name(), c.value());
            }
        }

        public List<Cookie> loadForRequest(HttpUrl url) {
            String host = url.host();
            return !this.cj.containsKey(host) ? new ArrayList<Cookie>() : FL.toAL(this.cj.get(host).entrySet().stream().map(e -> new Cookie.Builder().name((String)e.getKey()).value((String)e.getValue()).domain(host).build()));
        }
    }
}

