/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fastily.jwiki.core.NS;
import io.github.fastily.jwiki.core.WQuery;
import io.github.fastily.jwiki.core.Wiki;
import io.github.fastily.jwiki.dwrap.ImageInfo;
import io.github.fastily.jwiki.util.FL;
import io.github.fastily.jwiki.util.GSONP;
import io.github.fastily.jwiki.util.GroupQueue;
import io.github.fastily.jwiki.util.MultiMap;
import io.github.fastily.jwiki.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public final class MQuery {
    private static final int groupQueryMax = 50;

    private MQuery() {
    }

    private static MultiMap<String, JsonObject> getContProp(Wiki wiki, Collection<String> titles, WQuery.QTemplate qut, HashMap<String, String> pl, String elemArrKey) {
        MultiMap<String, JsonObject> l = new MultiMap<String, JsonObject>();
        if (FL.containsNull(titles)) {
            throw new IllegalArgumentException("null is not an acceptable title to query with");
        }
        GroupQueue<String> gq = new GroupQueue<String>(titles, 50);
        while (gq.has()) {
            WQuery wq = new WQuery(wiki, qut).set("titles", gq.poll());
            if (pl != null) {
                pl.forEach(wq::set);
            }
            while (wq.has()) {
                wq.next().propComp("title", elemArrKey).forEach((k, v) -> {
                    l.touch((String)k);
                    if (v != null) {
                        l.put((String)k, GSONP.getJAofJO(v.getAsJsonArray()));
                    }
                });
            }
        }
        return l;
    }

    private static HashMap<String, JsonElement> getNoContProp(Wiki wiki, Collection<String> titles, WQuery.QTemplate qut, HashMap<String, String> pl, String eKey) {
        HashMap<String, JsonElement> m = new HashMap<String, JsonElement>();
        if (FL.containsNull(titles)) {
            throw new IllegalArgumentException("null is not an acceptable title to query with");
        }
        GroupQueue<String> gq = new GroupQueue<String>(titles, 50);
        while (gq.has()) {
            WQuery wq = new WQuery(wiki, qut).set("titles", gq.poll());
            if (pl != null) {
                pl.forEach(wq::set);
            }
            m.putAll(wq.next().propComp("title", eKey));
        }
        return m;
    }

    private static ArrayList<JsonObject> getNoContList(Wiki wiki, Collection<String> titles, WQuery.QTemplate qut, HashMap<String, String> pl, String tQKey, String aKey) {
        ArrayList<JsonObject> l = new ArrayList<JsonObject>();
        if (FL.containsNull(titles)) {
            throw new IllegalArgumentException("null is not an acceptable title to query with");
        }
        GroupQueue<String> gq = new GroupQueue<String>(titles, 50);
        while (gq.has()) {
            WQuery wq = new WQuery(wiki, qut).set(tQKey, gq.poll());
            if (pl != null) {
                pl.forEach(wq::set);
            }
            l.addAll(wq.next().listComp(aKey));
        }
        return l;
    }

    private static HashMap<String, ArrayList<String>> parsePropToSingle(MultiMap<String, JsonObject> m, String elemKey) {
        HashMap<String, ArrayList<String>> xl = new HashMap<String, ArrayList<String>>();
        m.l.forEach((k, v) -> xl.put((String)k, FL.toAL(v.stream().map(e -> GSONP.getStr(e, elemKey)))));
        return xl;
    }

    private static HashMap<String, ArrayList<String>> parsePropToSingle(MultiMap<String, JsonObject> m) {
        return MQuery.parsePropToSingle(m, "title");
    }

    private static HashMap<String, ArrayList<Tuple<String, String>>> parsePropToDouble(MultiMap<String, JsonObject> m, String elemKey1, String elemKey2) {
        HashMap<String, ArrayList<Tuple<String, String>>> xl = new HashMap<String, ArrayList<Tuple<String, String>>>();
        m.l.forEach((k, v) -> xl.put((String)k, (ArrayList<Tuple<String, String>>)FL.toAL(v.stream().map(e -> new Tuple<String, String>(GSONP.getStr(e, elemKey1), GSONP.getStr(e, elemKey2))))));
        return xl;
    }

    public static HashMap<String, ArrayList<String>> listUserRights(Wiki wiki, Collection<String> users) {
        HashMap<String, ArrayList<String>> l = new HashMap<String, ArrayList<String>>();
        MQuery.getNoContList(wiki, users, WQuery.USERRIGHTS, null, "ususers", "users").forEach(jo -> l.put(GSONP.getStr(jo, "name"), jo.has("groups") ? GSONP.jaOfStrToAL(jo.getAsJsonArray("groups")) : null));
        return l;
    }

    public static HashMap<String, ArrayList<ImageInfo>> getImageInfo(Wiki wiki, Collection<String> titles) {
        HashMap<String, ArrayList<ImageInfo>> l = new HashMap<String, ArrayList<ImageInfo>>();
        MQuery.getContProp((Wiki)wiki, titles, (WQuery.QTemplate)WQuery.IMAGEINFO, null, (String)"imageinfo").l.forEach((k, v) -> l.put((String)k, FL.toAL(v.stream().map(jo -> (ImageInfo)GSONP.gson.fromJson((JsonElement)jo, ImageInfo.class)))));
        l.forEach((k, v) -> Collections.sort(v));
        return l;
    }

    public static HashMap<String, ArrayList<String>> getCategoriesOnPage(Wiki wiki, Collection<String> titles) {
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.PAGECATEGORIES, null, "categories"));
    }

    public static HashMap<String, Integer> getCategorySize(Wiki wiki, Collection<String> titles) {
        HashMap<String, Integer> l = new HashMap<String, Integer>();
        MQuery.getNoContProp(wiki, titles, WQuery.CATEGORYINFO, null, "categoryinfo").forEach((k, v) -> l.put((String)k, v == null ? 0 : v.getAsJsonObject().get("size").getAsInt()));
        return l;
    }

    public static HashMap<String, String> getPageText(Wiki wiki, Collection<String> titles) {
        HashMap<String, String> l = new HashMap<String, String>();
        MQuery.getNoContProp(wiki, titles, WQuery.PAGETEXT, null, "revisions").forEach((k, v) -> {
            if (v == null) {
                l.put((String)k, "");
            } else {
                ArrayList<JsonObject> jl = GSONP.getJAofJO(v.getAsJsonArray());
                l.put((String)k, jl.isEmpty() ? "" : GSONP.getStr(jl.get(0), "*"));
            }
        });
        return l;
    }

    public static HashMap<String, ArrayList<String>> getLinksOnPage(Wiki wiki, Collection<String> titles, NS ... ns) {
        HashMap<String, String> pl = new HashMap<String, String>();
        if (ns != null && ns.length > 0) {
            pl.put("plnamespace", wiki.nsl.createFilter(ns));
        }
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.LINKSONPAGE, pl, "links"));
    }

    public static HashMap<String, ArrayList<String>> linksHere(Wiki wiki, boolean redirects, Collection<String> titles) {
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.LINKSHERE, FL.pMap("lhshow", (redirects ? "" : "!") + "redirect"), "linkshere"));
    }

    public static HashMap<String, ArrayList<String>> transcludesIn(Wiki wiki, Collection<String> titles, NS ... ns) {
        HashMap<String, String> pl = new HashMap<String, String>();
        if (ns.length > 0) {
            pl.put("tinamespace", wiki.nsl.createFilter(ns));
        }
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.TRANSCLUDEDIN, pl, "transcludedin"));
    }

    public static HashMap<String, ArrayList<String>> fileUsage(Wiki wiki, Collection<String> titles) {
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.FILEUSAGE, null, "fileusage"));
    }

    public static HashMap<String, ArrayList<String>> getExternalLinks(Wiki wiki, Collection<String> titles) {
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.EXTLINKS, null, "extlinks"), "*");
    }

    public static HashMap<String, Boolean> exists(Wiki wiki, Collection<String> titles) {
        HashMap<String, Boolean> l = new HashMap<String, Boolean>();
        MQuery.getNoContProp(wiki, titles, WQuery.EXISTS, null, "missing").forEach((k, v) -> l.put((String)k, v == null));
        return l;
    }

    public static ArrayList<String> exists(Wiki wiki, boolean exists, Collection<String> titles) {
        ArrayList<String> l = new ArrayList<String>();
        MQuery.exists(wiki, titles).forEach((k, v) -> {
            if (v == exists) {
                l.add((String)k);
            }
        });
        return l;
    }

    public static HashMap<String, ArrayList<String>> getImagesOnPage(Wiki wiki, Collection<String> titles) {
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.IMAGES, null, "images"));
    }

    public static HashMap<String, ArrayList<String>> getTemplatesOnPage(Wiki wiki, Collection<String> titles) {
        return MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.TEMPLATES, null, "templates"));
    }

    public static HashMap<String, ArrayList<Tuple<String, String>>> globalUsage(Wiki wiki, Collection<String> titles) {
        return MQuery.parsePropToDouble(MQuery.getContProp(wiki, titles, WQuery.GLOBALUSAGE, null, "globalusage"), "title", "wiki");
    }

    public static HashMap<String, String> resolveRedirects(Wiki wiki, Collection<String> titles) {
        HashMap<String, String> l = new HashMap<String, String>();
        for (String s : titles) {
            l.put(s, s);
        }
        MQuery.getNoContList(wiki, titles, WQuery.RESOLVEREDIRECT, null, "titles", "redirects").forEach(jo -> l.put(GSONP.getStr(jo, "from"), GSONP.getStr(jo, "to")));
        return l;
    }

    public static HashMap<String, ArrayList<String>> getDuplicatesOf(Wiki wiki, boolean localOnly, Collection<String> titles) {
        HashMap<String, String> pl = new HashMap<String, String>();
        if (localOnly) {
            pl.put("dflocalonly", "");
        }
        HashMap<String, ArrayList<String>> l = MQuery.parsePropToSingle(MQuery.getContProp(wiki, titles, WQuery.DUPLICATEFILES, pl, "duplicatefiles"), "name");
        l.forEach((k, v) -> v.replaceAll(s -> wiki.convertIfNotInNS(s.replace('_', ' '), NS.FILE)));
        return l;
    }

    public static HashMap<String, ArrayList<String>> getSharedDuplicatesOf(Wiki wiki, Collection<String> titles) {
        HashMap<String, ArrayList<Tuple<String, String>>> xl = MQuery.parsePropToDouble(MQuery.getContProp(wiki, titles, WQuery.DUPLICATEFILES, null, "duplicatefiles"), "name", "shared");
        HashMap<String, ArrayList<String>> l = new HashMap<String, ArrayList<String>>();
        xl.forEach((k, v) -> l.put((String)k, FL.toAL(v.stream().filter(t -> t.y != null).map(t -> wiki.convertIfNotInNS(((String)t.x).replace('_', ' '), NS.FILE)))));
        return l;
    }

    public static HashMap<String, String> getTextExtracts(Wiki wiki, Collection<String> titles) {
        HashMap<String, String> l = new HashMap<String, String>();
        MQuery.getNoContProp(wiki, titles, WQuery.TEXTEXTRACTS, null, "extract").forEach((k, v) -> l.put((String)k, v == null ? null : v.getAsString()));
        return l;
    }
}

