/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.core;

import com.google.gson.JsonObject;
import io.github.fastily.jwiki.util.FL;
import io.github.fastily.jwiki.util.GSONP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class NS {
    public static final NS MAIN = new NS(0);
    public static final NS TALK = new NS(1);
    public static final NS USER = new NS(2);
    public static final NS USER_TALK = new NS(3);
    public static final NS PROJECT = new NS(4);
    public static final NS PROJECT_TALK = new NS(5);
    public static final NS FILE = new NS(6);
    public static final NS FILE_TALK = new NS(7);
    public static final NS MEDIAWIKI = new NS(8);
    public static final NS MEDIAWIKI_TALK = new NS(9);
    public static final NS TEMPLATE = new NS(10);
    public static final NS TEMPLATE_TALK = new NS(11);
    public static final NS HELP = new NS(12);
    public static final NS HELP_TALK = new NS(13);
    public static final NS CATEGORY = new NS(14);
    public static final NS CATEGORY_TALK = new NS(15);
    public final int v;

    protected NS(int v) {
        this.v = v;
    }

    public int hashCode() {
        return this.v;
    }

    public boolean equals(Object x) {
        return x instanceof NS && this.v == ((NS)x).v;
    }

    protected static class NSManager {
        protected final HashMap<Object, Object> nsM = new HashMap();
        protected final ArrayList<String> nsL = new ArrayList();
        protected final String nssRegex;
        protected final Pattern p;

        protected NSManager(JsonObject r) {
            String name;
            for (JsonObject x : GSONP.getJOofJO(r.getAsJsonObject("namespaces"))) {
                name = x.get("*").getAsString();
                if (name.isEmpty()) {
                    name = "Main";
                }
                int id = x.get("id").getAsInt();
                this.nsM.put(name, id);
                this.nsM.put(id, name);
                this.nsL.add(name);
            }
            for (JsonObject x : GSONP.getJAofJO(r.getAsJsonArray("namespacealiases"))) {
                name = x.get("*").getAsString();
                this.nsM.put(name, x.get("id").getAsInt());
                this.nsL.add(name);
            }
            this.nssRegex = String.format("(?i)^(%s):", FL.pipeFence(FL.toAL(this.nsL.stream().map(s -> s.replace(" ", "(_| )")))));
            this.p = Pattern.compile(this.nssRegex);
        }

        protected String createFilter(NS ... nsl) {
            return FL.pipeFence(FL.toSet(Stream.of(nsl).map(e -> "" + e.v)));
        }
    }
}

