/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.fastily.jwiki.core.Wiki;
import io.github.fastily.jwiki.util.FL;
import io.github.fastily.jwiki.util.GSONP;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

class WAction {
    private WAction() {
    }

    protected static ActionResult postAction(Wiki wiki, String action, boolean applyToken, HashMap<String, String> form) {
        HashMap<String, String> fl = FL.pMap("format", "json");
        if (applyToken) {
            fl.put("token", wiki.conf.token);
        }
        fl.putAll(form);
        try {
            JsonObject result = JsonParser.parseString((String)wiki.apiclient.basicPOST(FL.pMap("action", action), fl).body().string()).getAsJsonObject();
            if (wiki.debug) {
                wiki.conf.log.debug(wiki, GSONP.gsonPP.toJson((JsonElement)result));
            }
            return ActionResult.wrap(result, action);
        }
        catch (Throwable e) {
            return ActionResult.NONE;
        }
    }

    protected static boolean addText(Wiki wiki, String title, String text, String summary, boolean append) {
        wiki.conf.log.info(wiki, "Adding text to " + title);
        HashMap<String, String> pl = FL.pMap("title", title, append ? "appendtext" : "prependtext", text, "summary", summary);
        if (wiki.conf.isBot) {
            pl.put("bot", "");
        }
        return WAction.postAction(wiki, "edit", true, pl) == ActionResult.SUCCESS;
    }

    protected static boolean edit(Wiki wiki, String title, String text, String summary) {
        wiki.conf.log.info(wiki, "Editing " + title);
        HashMap<String, String> pl = FL.pMap("title", title, "text", text, "summary", summary);
        if (wiki.conf.isBot) {
            pl.put("bot", "");
        }
        block7: for (int i = 0; i < 5; ++i) {
            switch (WAction.postAction(wiki, "edit", true, pl)) {
                case SUCCESS: {
                    return true;
                }
                case RATELIMITED: {
                    try {
                        wiki.conf.log.fyi(wiki, "Ratelimited by server, sleeping 10 seconds");
                        Thread.sleep(10000L);
                        continue block7;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                case PROTECTED: {
                    wiki.conf.log.error(wiki, title + " is protected, cannot edit.");
                    return false;
                }
                default: {
                    wiki.conf.log.warn(wiki, "Got an error, retrying: " + i);
                }
            }
        }
        wiki.conf.log.error(wiki, String.format("Could not edit '%s', aborting.", title));
        return false;
    }

    protected static boolean move(Wiki wiki, String title, String newTitle, boolean moveTalk, boolean moveSubpages, boolean supressRedirect, String reason) {
        wiki.conf.log.info(wiki, String.format("Moving %s to %s", title, newTitle));
        HashMap<String, String> pl = FL.pMap("from", title, "to", newTitle, "reason", reason);
        if (moveTalk) {
            pl.put("movetalk", "1");
        }
        if (moveSubpages) {
            pl.put("movesubpages", "1");
        }
        if (supressRedirect) {
            pl.put("noredirect", "1");
        }
        return WAction.postAction(wiki, "move", true, pl) == ActionResult.NONE;
    }

    protected static boolean delete(Wiki wiki, String title, String reason) {
        wiki.conf.log.info(wiki, "Deleting " + title);
        return WAction.postAction(wiki, "delete", true, FL.pMap("title", title, "reason", reason)) == ActionResult.NONE;
    }

    protected static boolean undelete(Wiki wiki, String title, String reason) {
        wiki.conf.log.info(wiki, "Restoring " + title);
        for (int i = 0; i < 10; ++i) {
            if (WAction.postAction(wiki, "undelete", true, FL.pMap("title", title, "reason", reason)) != ActionResult.NONE) continue;
            return true;
        }
        return false;
    }

    protected static void purge(Wiki wiki, ArrayList<String> titles) {
        wiki.conf.log.info(wiki, "Purging:" + titles);
        HashMap<String, String> pl = FL.pMap("titles", FL.pipeFence(titles));
        WAction.postAction(wiki, "purge", false, pl);
    }

    protected static boolean upload(Wiki wiki, String title, String desc, String summary, Path file) {
        wiki.conf.log.info(wiki, "Uploading " + file);
        try {
            Chunk c;
            ChunkManager cm = new ChunkManager(file);
            String filekey = null;
            String fn = file.getFileName().toString();
            block4: while ((c = cm.nextChunk()) != null) {
                wiki.conf.log.fyi(wiki, String.format("Uploading chunk [%d of %d] of '%s'", cm.chunkCnt, cm.totalChunks, file));
                HashMap<String, String> pl = FL.pMap("format", "json", "filename", title, "token", wiki.conf.token, "ignorewarnings", "1", "stash", "1", "offset", "" + c.offset, "filesize", "" + c.filesize);
                if (filekey != null) {
                    pl.put("filekey", filekey);
                }
                for (int i = 0; i < 5; ++i) {
                    try {
                        Response r = wiki.apiclient.multiPartFilePOST(FL.pMap("action", "upload"), pl, fn, c.bl);
                        if (!r.isSuccessful()) {
                            wiki.conf.log.error(wiki, "Bad response from server: " + r.code());
                            continue;
                        }
                        filekey = GSONP.getStr(JsonParser.parseString((String)r.body().string()).getAsJsonObject().getAsJsonObject("upload"), "filekey");
                        if (filekey == null) continue;
                        continue block4;
                    }
                    catch (Throwable e) {
                        wiki.conf.log.error(wiki, "Encountered an error, retrying - " + i);
                        e.printStackTrace();
                    }
                }
            }
            for (int i = 0; i < 3; ++i) {
                wiki.conf.log.info(wiki, String.format("Unstashing '%s' as '%s'", filekey, title));
                if (WAction.postAction(wiki, "upload", true, FL.pMap("filename", title, "text", desc, "comment", summary, "filekey", filekey, "ignorewarnings", "true")) == ActionResult.SUCCESS) {
                    return true;
                }
                wiki.conf.log.error(wiki, "Encountered an error while unstashing, retrying - " + i);
            }
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static boolean uploadByUrl(Wiki wiki, HttpUrl url, String title, String desc, String summary) {
        wiki.conf.log.info(wiki, String.format("Uploading '%s' to '%s'", url, title));
        return WAction.postAction(wiki, "upload", true, FL.pMap("filename", title, "text", desc, "comment", summary, "ignorewarnings", "true", "url", url.toString())) == ActionResult.SUCCESS;
    }

    protected static enum ActionResult {
        SUCCESS,
        ERROR,
        NONE,
        BADTOKEN,
        NOTOKEN,
        PROTECTED,
        RATELIMITED;


        private static ActionResult wrap(JsonObject jo, String action) {
            try {
                if (jo.has(action)) {
                    switch (GSONP.getStr(jo.getAsJsonObject(action), "result")) {
                        case "Success": {
                            return SUCCESS;
                        }
                    }
                    System.err.printf("Something isn't right.  Got back '%s', missing a 'result'?%n", GSONP.gson.toJson((JsonElement)jo));
                } else if (jo.has("error")) {
                    switch (GSONP.getStr(jo.getAsJsonObject("error"), "code")) {
                        case "notoken": {
                            return NOTOKEN;
                        }
                        case "badtoken": {
                            return BADTOKEN;
                        }
                        case "cascadeprotected": 
                        case "protectedpage": {
                            return PROTECTED;
                        }
                    }
                    return ERROR;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return NONE;
        }
    }

    private static final class ChunkManager {
        private static final int chunksize = 0x400000;
        private BufferedSource src;
        private long offset = 0L;
        private final long filesize;
        private final long totalChunks;
        private int chunkCnt = 0;

        private ChunkManager(Path fn) throws IOException {
            this.filesize = Files.size(fn);
            this.src = Okio.buffer((Source)Okio.source((Path)fn, (OpenOption[])new OpenOption[]{StandardOpenOption.READ}));
            this.totalChunks = this.filesize / 0x400000L + (long)(this.filesize % 0x400000L > 0L ? 1 : 0);
        }

        private boolean has() {
            return this.offset < this.filesize;
        }

        private Chunk nextChunk() {
            if (!this.has()) {
                return null;
            }
            try {
                Chunk c = new Chunk(this.offset, this.filesize, (long)(++this.chunkCnt) == this.totalChunks ? this.src.readByteArray() : this.src.readByteArray(0x400000L));
                this.offset += 0x400000L;
                if (!this.has()) {
                    this.src.close();
                }
                return c;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static final class Chunk {
        protected final long offset;
        protected final long filesize;
        protected final byte[] bl;

        private Chunk(long offset, long filesize, byte[] bl) {
            this.offset = offset;
            this.filesize = filesize;
            this.bl = bl;
        }
    }
}

