/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.core;

import com.google.gson.JsonParser;
import io.github.fastily.jwiki.core.NS;
import io.github.fastily.jwiki.core.Wiki;
import io.github.fastily.jwiki.util.FL;
import io.github.fastily.jwiki.util.GSONP;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WParser {
    private WParser() {
    }

    private static WikiText parse(Wiki wiki, HashMap<String, String> queryParams) {
        queryParams.put("prop", "parsetree");
        try {
            XMLEventReader r = XMLInputFactory.newInstance().createXMLEventReader(new StringReader(GSONP.getStr(GSONP.getNestedJO(JsonParser.parseString((String)wiki.basicPOST("parse", queryParams).body().string()).getAsJsonObject(), FL.toSAL("parse", "parsetree")), "*")));
            WikiText root = new WikiText(new Object[0]);
            while (r.hasNext()) {
                XMLEvent e = r.nextEvent();
                if (e.isStartElement() && WParser.nameIs(e.asStartElement(), "template")) {
                    root.append(WParser.parseTemplate(r, root));
                    continue;
                }
                if (!e.isCharacters()) continue;
                root.append(WParser.cToStr(e));
            }
            return root;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WikiText parsePage(Wiki wiki, String page) {
        return WParser.parse(wiki, FL.pMap("page", page));
    }

    public static WikiText parseText(Wiki wiki, String text) {
        return WParser.parse(wiki, FL.pMap("text", text, "contentmodel", "wikitext"));
    }

    private static WTemplate parseTemplate(XMLEventReader r, WikiText parent) throws Throwable {
        WTemplate t = new WTemplate(parent);
        String lastNameParsed = "";
        while (r.hasNext()) {
            XMLEvent e = r.nextEvent();
            if (e.isStartElement()) {
                StartElement se = e.asStartElement();
                switch (se.getName().getLocalPart()) {
                    case "title": {
                        t.title = WParser.getNextElementText(r).strip();
                        break;
                    }
                    case "name": {
                        Attribute index = se.getAttributeByName(new QName("index"));
                        lastNameParsed = index != null ? index.getValue() : WParser.getNextElementText(r).strip();
                        break;
                    }
                    case "equals": {
                        WParser.getNextElementText(r);
                        break;
                    }
                    case "value": {
                        t.put(lastNameParsed, WParser.parseTValue(r));
                        break;
                    }
                }
                continue;
            }
            if (!e.isEndElement() || !WParser.nameIs(e.asEndElement(), "template")) continue;
            break;
        }
        return t;
    }

    private static WikiText parseTValue(XMLEventReader r) throws Throwable {
        WikiText root = new WikiText(new Object[0]);
        while (r.hasNext()) {
            XMLEvent e = r.nextEvent();
            if (e.isStartElement() && WParser.nameIs(e.asStartElement(), "template")) {
                root.append(WParser.parseTemplate(r, root));
                continue;
            }
            if (e.isCharacters()) {
                root.append(WParser.cToStr(e));
                continue;
            }
            if (!e.isEndElement() || !WParser.nameIs(e.asEndElement(), "value")) continue;
            break;
        }
        return root;
    }

    private static String getNextElementText(XMLEventReader r) throws Throwable {
        StringBuilder x = new StringBuilder();
        while (r.hasNext()) {
            XMLEvent e = r.nextEvent();
            if (e.isStartElement()) {
                WParser.getNextElementText(r);
                continue;
            }
            if (e.isCharacters()) {
                x.append(WParser.cToStr(e));
                continue;
            }
            if (!e.isEndElement()) continue;
            break;
        }
        return x.toString();
    }

    private static String cToStr(XMLEvent e) {
        return e.asCharacters().getData();
    }

    private static boolean nameIs(StartElement e, String n) {
        return e.getName().getLocalPart().equals(n);
    }

    private static boolean nameIs(EndElement e, String n) {
        return e.getName().getLocalPart().equals(n);
    }

    public static class WikiText {
        protected ArrayDeque<Object> l = new ArrayDeque();

        public WikiText(Object ... objects) {
            for (Object o : objects) {
                this.append(o);
            }
        }

        public void append(Object o) {
            if (o instanceof String) {
                this.l.add((this.l.peekLast() instanceof String ? this.l.pollLast().toString() : "") + o);
            } else if (o instanceof WTemplate) {
                WTemplate t = (WTemplate)o;
                t.parent = this;
                this.l.add(o);
            } else {
                throw new IllegalArgumentException("What is '" + o + "' ?");
            }
        }

        public ArrayList<WTemplate> getTemplates() {
            return FL.toAL(this.l.stream().filter(o -> o instanceof WTemplate).map(o -> (WTemplate)o));
        }

        public ArrayList<WTemplate> getTemplatesR() {
            ArrayList<WTemplate> wtl = new ArrayList<WTemplate>();
            this.getTemplatesR(wtl);
            return wtl;
        }

        private void getTemplatesR(ArrayList<WTemplate> wtl) {
            this.l.stream().filter(o -> o instanceof WTemplate).map(o -> (WTemplate)o).forEach(t -> {
                for (WikiText wt : t.params.values()) {
                    wt.getTemplatesR(wtl);
                }
                wtl.add((WTemplate)t);
            });
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean doTrim) {
            StringBuilder b = new StringBuilder("");
            for (Object o : this.l) {
                b.append(o);
            }
            String out = b.toString();
            return doTrim ? out.strip() : out;
        }
    }

    public static class WTemplate {
        protected WikiText parent;
        public String title = "";
        protected LinkedHashMap<String, WikiText> params = new LinkedHashMap();

        public WTemplate() {
            this(null);
        }

        protected WTemplate(WikiText parent) {
            this.parent = parent;
        }

        public void normalizeTitle(Wiki wiki) {
            if (wiki.whichNS(this.title).equals(NS.TEMPLATE)) {
                this.title = wiki.nss(this.title);
            }
            this.title = this.title.length() <= 1 ? this.title.toUpperCase() : Character.toUpperCase(this.title.charAt(0)) + this.title.substring(1);
            this.title = this.title.replace('_', ' ');
        }

        public boolean has(String k) {
            return this.params.containsKey(k) && !this.params.get((Object)k).l.isEmpty();
        }

        public WikiText get(String k) {
            return this.params.get(k);
        }

        public void put(String k, Object v) {
            if (v instanceof WikiText) {
                this.params.put(k, (WikiText)v);
            } else if (v instanceof String || v instanceof WTemplate) {
                this.params.put(k, new WikiText(v));
            } else {
                throw new IllegalArgumentException(String.format("'%s' is not an acceptable type", v));
            }
        }

        public void append(String k, Object o) {
            if (this.has(k)) {
                this.params.get(k).append(o);
            } else {
                this.put(k, o);
            }
        }

        public void remove(String k) {
            this.params.remove(k);
        }

        public void drop() {
            if (this.parent == null) {
                return;
            }
            this.parent.l.remove(this);
            this.parent = null;
        }

        public void remap(String oldK, String newK) {
            this.params.put(newK, (WikiText)this.params.remove(oldK));
        }

        public HashSet<String> keySet() {
            return new HashSet<String>(this.params.keySet());
        }

        public String toString(boolean indent) {
            String base = (indent ? "%n" : "") + "|%s=%s";
            Object x = "";
            for (Map.Entry<String, WikiText> e : this.params.entrySet()) {
                x = (String)x + String.format(base, e.getKey(), e.getValue());
            }
            if (indent) {
                x = (String)x + "\n";
            }
            return String.format("{{%s%s}}", this.title, x);
        }

        public String toString() {
            return this.toString(false);
        }
    }
}

