/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.fastily.jwiki.core.ApiClient;
import io.github.fastily.jwiki.core.Conf;
import io.github.fastily.jwiki.core.MQuery;
import io.github.fastily.jwiki.core.NS;
import io.github.fastily.jwiki.core.WAction;
import io.github.fastily.jwiki.core.WQuery;
import io.github.fastily.jwiki.dwrap.Contrib;
import io.github.fastily.jwiki.dwrap.ImageInfo;
import io.github.fastily.jwiki.dwrap.LogEntry;
import io.github.fastily.jwiki.dwrap.PageSection;
import io.github.fastily.jwiki.dwrap.ProtectedTitleEntry;
import io.github.fastily.jwiki.dwrap.RCEntry;
import io.github.fastily.jwiki.dwrap.Revision;
import io.github.fastily.jwiki.util.FL;
import io.github.fastily.jwiki.util.GSONP;
import io.github.fastily.jwiki.util.Tuple;
import java.net.Proxy;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import okhttp3.HttpUrl;
import okhttp3.Response;

public class Wiki {
    public boolean debug = false;
    private HashMap<String, Wiki> wl = new HashMap();
    protected NS.NSManager nsl;
    protected Conf conf = new Conf();
    protected ApiClient apiclient;

    private Wiki() {
    }

    private Wiki(HttpUrl apiEndpoint, Wiki parent) {
        this.conf.log.enabled = parent.conf.log.enabled;
        this.conf.retarget(apiEndpoint);
        this.wl = parent.wl;
        this.apiclient = new ApiClient(parent, this);
        this.refreshLoginStatus();
        this.refreshNS();
    }

    public synchronized boolean login(String user, String password) {
        if (this.conf.uname != null) {
            return true;
        }
        this.conf.log.info(this, "Try login for " + user);
        try {
            if (WAction.postAction(this, "login", false, FL.pMap("lgname", user, "lgpassword", password, "lgtoken", this.getTokens(WQuery.TOKENS_LOGIN, "logintoken"))) == WAction.ActionResult.SUCCESS) {
                this.refreshLoginStatus();
                this.conf.log.info(this, "Logged in as " + user);
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public void refreshLoginStatus() {
        this.conf.uname = GSONP.getStr(new WQuery(this, WQuery.USERINFO).next().metaComp("userinfo").getAsJsonObject(), "name");
        this.conf.token = this.getTokens(WQuery.TOKENS_CSRF, "csrftoken");
        this.wl.put(this.conf.hostname, this);
        this.conf.isBot = this.listUserRights(this.conf.uname).contains("bot");
    }

    private String getTokens(WQuery.QTemplate wqt, String tk) {
        try {
            return GSONP.getStr(new WQuery(this, wqt).next().metaComp("tokens").getAsJsonObject(), tk);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Response basicGET(String action, String ... params) {
        HashMap<String, String> pl = FL.pMap(params);
        pl.put("action", action);
        pl.put("format", "json");
        try {
            return this.apiclient.basicGET(pl);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Response basicPOST(String action, HashMap<String, String> form) {
        form.put("format", "json");
        try {
            return this.apiclient.basicPOST(FL.pMap("action", action), form);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void refreshNS() {
        this.conf.log.info(this, "Fetching Namespace List");
        this.nsl = new NS.NSManager(new WQuery((Wiki)this, (WQuery.QTemplate[])new WQuery.QTemplate[]{WQuery.NAMESPACES}).next().input.getAsJsonObject("query"));
    }

    public String convertIfNotInNS(String title, NS ns) {
        return this.whichNS(title).equals(ns) ? title : String.format("%s:%s", this.nsl.nsM.get(ns.v), this.nss(title));
    }

    public ArrayList<String> filterByNS(ArrayList<String> pages, NS ... ns) {
        HashSet<NS> l = new HashSet<NS>(Arrays.asList(ns));
        return FL.toAL(pages.stream().filter(s -> l.contains(this.whichNS((String)s))));
    }

    public NS getNS(String prefix) {
        if (prefix.isEmpty() || prefix.equalsIgnoreCase("main")) {
            return NS.MAIN;
        }
        return this.nsl.nsM.containsKey(prefix) ? new NS((Integer)this.nsl.nsM.get(prefix)) : null;
    }

    public synchronized Wiki getWiki(String domain) {
        if (this.conf.uname == null) {
            return null;
        }
        this.conf.log.fyi(this, String.format("Get Wiki for %s @ %s", this.whoami(), domain));
        try {
            return this.wl.containsKey(domain) ? this.wl.get(domain) : new Wiki(this.conf.baseURL.newBuilder().host(domain).build(), this);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public String nss(String title) {
        return title.replaceAll(this.nsl.nssRegex, "");
    }

    public ArrayList<String> nss(Collection<String> l) {
        return FL.toAL(l.stream().map(this::nss));
    }

    public String talkPageOf(String title) {
        int i = this.whichNS((String)title).v;
        return i < 0 || i % 2 == 1 ? null : (String)this.nsl.nsM.get(i + 1) + ":" + this.nss(title);
    }

    public String talkPageBelongsTo(String title) {
        NS ns = this.whichNS(title);
        if (ns.v < 0 || ns.v % 2 == 0) {
            return null;
        }
        if (ns.equals(NS.TALK)) {
            return this.nss(title);
        }
        return (String)this.nsl.nsM.get(ns.v - 1) + ":" + this.nss(title);
    }

    public NS whichNS(String title) {
        Matcher m = this.nsl.p.matcher(title);
        return !m.find() ? NS.MAIN : new NS((Integer)this.nsl.nsM.get(title.substring(m.start(), m.end() - 1)));
    }

    public String whoami() {
        return this.conf.uname == null ? "<Anonymous>" : this.conf.uname;
    }

    public String toString() {
        return String.format("[%s @ %s]", this.whoami(), this.conf.hostname);
    }

    public boolean addText(String title, String add, String reason, boolean top) {
        return WAction.addText(this, title, add, reason, !top);
    }

    public boolean edit(String title, String text, String reason) {
        return WAction.edit(this, title, text, reason);
    }

    public boolean delete(String title, String reason) {
        return WAction.delete(this, title, reason);
    }

    public boolean move(String title, String newTitle, boolean moveTalk, boolean moveSubpages, boolean supressRedirect, String reason) {
        return WAction.move(this, title, newTitle, moveTalk, moveSubpages, supressRedirect, reason);
    }

    public void purge(String ... titles) {
        WAction.purge(this, FL.toSAL(titles));
    }

    public boolean replaceText(String title, String regex, String reason) {
        return this.replaceText(title, regex, "", reason);
    }

    public boolean replaceText(String title, String regex, String replacement, String reason) {
        String s = this.getPageText(title);
        String rx = s.replaceAll(regex, replacement);
        return rx.equals(s) || this.edit(title, rx, reason);
    }

    public boolean undelete(String title, String reason) {
        return WAction.undelete(this, title, reason);
    }

    public boolean upload(Path p, String title, String text, String reason) {
        return WAction.upload(this, title, text, reason, p);
    }

    public boolean uploadByUrl(HttpUrl url, String title, String desc, String summary) {
        return WAction.uploadByUrl(this, url, title, desc, summary);
    }

    public ArrayList<String> allPages(String prefix, boolean redirectsOnly, boolean protectedOnly, int cap, NS ns) {
        this.conf.log.info(this, "Doing all pages fetch for " + (prefix == null ? "all pages" : prefix));
        WQuery wq = new WQuery(this, cap, WQuery.ALLPAGES);
        if (prefix != null) {
            wq.set("apprefix", prefix);
        }
        if (ns != null) {
            wq.set("apnamespace", "" + ns.v);
        }
        if (redirectsOnly) {
            wq.set("apfilterredir", "redirects");
        }
        if (protectedOnly) {
            wq.set("apprtype", "edit|move|upload");
        }
        ArrayList<String> l = new ArrayList<String>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("allpages").stream().map(jo -> GSONP.getStr(jo, "title"))));
        }
        return l;
    }

    public boolean exists(String title) {
        this.conf.log.info(this, "Checking to see if title exists: " + title);
        return MQuery.exists(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> fileUsage(String title) {
        this.conf.log.info(this, "Fetching local file usage of " + title);
        return MQuery.fileUsage(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> getAllowedFileExts() {
        this.conf.log.info(this, "Fetching a list of permissible file extensions");
        return FL.toAL(new WQuery(this, WQuery.ALLOWEDFILEXTS).next().listComp("fileextensions").stream().map(e -> GSONP.getStr(e, "ext")));
    }

    public ArrayList<String> getCategoriesOnPage(String title) {
        this.conf.log.info(this, "Getting categories of " + title);
        return MQuery.getCategoriesOnPage(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> getCategoryMembers(String title, NS ... ns) {
        this.conf.log.info(this, "Getting category members from " + title);
        WQuery wq = new WQuery(this, WQuery.CATEGORYMEMBERS).set("cmtitle", this.convertIfNotInNS(title, NS.CATEGORY));
        if (ns.length > 0) {
            wq.set("cmnamespace", this.nsl.createFilter(ns));
        }
        ArrayList<String> l = new ArrayList<String>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("categorymembers").stream().map(e -> GSONP.getStr(e, "title"))));
        }
        return l;
    }

    public int getCategorySize(String title) {
        this.conf.log.info(this, "Getting category size of " + title);
        return MQuery.getCategorySize(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<Contrib> getContribs(String user, int cap, boolean olderFirst, boolean createdOnly, NS ... ns) {
        this.conf.log.info(this, "Fetching contribs of " + user);
        WQuery wq = new WQuery(this, cap, WQuery.USERCONTRIBS).set("ucuser", user);
        if (ns.length > 0) {
            wq.set("ucnamespace", this.nsl.createFilter(ns));
        }
        if (olderFirst) {
            wq.set("ucdir", "newer");
        }
        if (createdOnly) {
            wq.set("ucshow", "new");
        }
        ArrayList<Contrib> l = new ArrayList<Contrib>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("usercontribs").stream().map(jo -> (Contrib)GSONP.gson.fromJson((JsonElement)jo, Contrib.class))));
        }
        return l;
    }

    public ArrayList<String> getDuplicatesOf(String title, boolean localOnly) {
        this.conf.log.info(this, "Getting duplicates of " + title);
        return MQuery.getDuplicatesOf(this, localOnly, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> getExternalLinks(String title) {
        this.conf.log.info(this, "Getting external links on " + title);
        return MQuery.getExternalLinks(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<ImageInfo> getImageInfo(String title) {
        this.conf.log.info(this, "Getting image info for " + title);
        return MQuery.getImageInfo(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> getImagesOnPage(String title) {
        this.conf.log.info(this, "Getting files on " + title);
        return MQuery.getImagesOnPage(this, FL.toSAL(title)).get(title);
    }

    public String getLastEditor(String title) {
        try {
            return this.getRevisions((String)title, (int)1, (boolean)false, null, null).get((int)0).user;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<String> getLinksOnPage(String title, NS ... ns) {
        this.conf.log.info(this, "Getting wiki links on " + title);
        return MQuery.getLinksOnPage(this, FL.toSAL(title), ns).get(title);
    }

    public ArrayList<String> getLinksOnPage(boolean exists, String title, NS ... ns) {
        return FL.toAL(MQuery.exists(this, this.getLinksOnPage(title, ns)).entrySet().stream().filter(t -> (Boolean)t.getValue() == exists).map(Map.Entry::getKey));
    }

    public ArrayList<LogEntry> getLogs(String title, String user, String type, int cap) {
        this.conf.log.info(this, String.format("Fetching log entries -> title: %s, user: %s, type: %s", title, user, type));
        WQuery wq = new WQuery(this, cap, WQuery.LOGEVENTS);
        if (title != null) {
            wq.set("letitle", title);
        }
        if (user != null) {
            wq.set("leuser", this.nss(user));
        }
        if (type != null) {
            wq.set("letype", type);
        }
        ArrayList<LogEntry> l = new ArrayList<LogEntry>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("logevents").stream().map(jo -> (LogEntry)GSONP.gson.fromJson((JsonElement)jo, LogEntry.class))));
        }
        return l;
    }

    public String getPageCreator(String title) {
        try {
            return this.getRevisions((String)title, (int)1, (boolean)true, null, null).get((int)0).user;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPageText(String title) {
        this.conf.log.info(this, "Getting page text of " + title);
        return MQuery.getPageText(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<ProtectedTitleEntry> getProtectedTitles(int limit, boolean olderFirst, NS ... ns) {
        this.conf.log.info(this, "Fetching a list of protected titles");
        WQuery wq = new WQuery(this, limit, WQuery.PROTECTEDTITLES);
        if (ns.length > 0) {
            wq.set("ptnamespace", this.nsl.createFilter(ns));
        }
        if (olderFirst) {
            wq.set("ptdir", "newer");
        }
        ArrayList<ProtectedTitleEntry> l = new ArrayList<ProtectedTitleEntry>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("protectedtitles").stream().map(jo -> (ProtectedTitleEntry)GSONP.gson.fromJson((JsonElement)jo, ProtectedTitleEntry.class))));
        }
        return l;
    }

    public ArrayList<String> getRandomPages(int limit, NS ... ns) {
        this.conf.log.info(this, "Fetching random page(s)");
        if (limit < 0) {
            throw new IllegalArgumentException("limit for getRandomPages() cannot be a negative number");
        }
        ArrayList<String> l = new ArrayList<String>();
        WQuery wq = new WQuery(this, limit, WQuery.RANDOM);
        if (ns.length > 0) {
            wq.set("rnnamespace", this.nsl.createFilter(ns));
        }
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("random").stream().map(e -> GSONP.getStr(e, "title"))));
        }
        return l;
    }

    public ArrayList<RCEntry> getRecentChanges(Instant start, Instant end) {
        this.conf.log.info(this, "Querying recent changes");
        Instant s = start;
        Instant e = end;
        if (s == null) {
            e = Instant.now();
            s = e.minusSeconds(30L);
        } else if (e != null && e.isBefore(s)) {
            throw new IllegalArgumentException("start is before end, cannot proceed");
        }
        WQuery wq = new WQuery(this, WQuery.RECENTCHANGES).set("rcend", s.toString());
        if (e != null) {
            wq.set("rcstart", e.toString());
        }
        ArrayList<RCEntry> l = new ArrayList<RCEntry>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("recentchanges").stream().map(jo -> (RCEntry)GSONP.gson.fromJson((JsonElement)jo, RCEntry.class))));
        }
        return l;
    }

    public ArrayList<Revision> getRevisions(String title, int cap, boolean olderFirst, Instant start, Instant end) {
        this.conf.log.info(this, "Getting revisions from " + title);
        WQuery wq = new WQuery(this, cap, WQuery.REVISIONS).set("titles", title);
        if (olderFirst) {
            wq.set("rvdir", "newer");
        }
        if (start != null && end != null && start.isBefore(end)) {
            wq.set("rvstart", end.toString());
            wq.set("rvend", start.toString());
        }
        ArrayList<Revision> l = new ArrayList<Revision>();
        while (wq.has()) {
            JsonElement e = wq.next().propComp("title", "revisions").get(title);
            if (e == null) continue;
            l.addAll(FL.toAL(GSONP.getJAofJO(e.getAsJsonArray()).stream().map(jo -> (Revision)GSONP.gson.fromJson((JsonElement)jo, Revision.class))));
        }
        return l;
    }

    public ArrayList<String> getSharedDuplicatesOf(String title) {
        this.conf.log.info(this, "Getting shared duplicates of " + title);
        return MQuery.getSharedDuplicatesOf(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> getTemplatesOnPage(String title) {
        this.conf.log.info(this, "Getting templates transcluded on " + title);
        return MQuery.getTemplatesOnPage(this, FL.toSAL(title)).get(title);
    }

    public String getTextExtract(String title) {
        this.conf.log.info(this, "Getting a text extract for " + title);
        return MQuery.getTextExtracts(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> getUserUploads(String user) {
        this.conf.log.info(this, "Fetching uploads for " + user);
        ArrayList<String> l = new ArrayList<String>();
        WQuery wq = new WQuery(this, WQuery.USERUPLOADS).set("aiuser", this.nss(user));
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("allimages").stream().map(e -> GSONP.getStr(e, "title"))));
        }
        return l;
    }

    public ArrayList<Tuple<String, String>> globalUsage(String title) {
        this.conf.log.info(this, "Getting global usage for " + title);
        return MQuery.globalUsage(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> listUserRights(String user) {
        this.conf.log.info(this, "Getting user rights for " + user);
        return MQuery.listUserRights(this, FL.toSAL(user)).get(user);
    }

    public ArrayList<String> prefixIndex(NS namespace, String prefix) {
        this.conf.log.info(this, "Doing prefix index search for " + prefix);
        return this.allPages(prefix, false, false, -1, namespace);
    }

    public ArrayList<String> querySpecialPage(String title, int cap) {
        this.conf.log.info(this, "Querying special page " + title);
        WQuery wq = new WQuery(this, cap, WQuery.QUERYPAGES).set("qppage", this.nss(title));
        ArrayList<String> l = new ArrayList<String>();
        while (wq.has()) {
            try {
                l.addAll(FL.toAL(FL.streamFrom(GSONP.getNestedJA(wq.next().input, FL.toSAL("query", "querypage", "results"))).map(e -> GSONP.getStr(e.getAsJsonObject(), "title"))));
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
        return l;
    }

    public String resolveRedirect(String title) {
        this.conf.log.info(this, "Resolving redirect for " + title);
        return MQuery.resolveRedirects(this, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> search(String query, int limit, NS ... ns) {
        WQuery wq = new WQuery(this, limit, WQuery.SEARCH).set("srsearch", query);
        if (ns.length > 0) {
            wq.set("srnamespace", this.nsl.createFilter(ns));
        }
        ArrayList<String> l = new ArrayList<String>();
        while (wq.has()) {
            l.addAll(FL.toAL(wq.next().listComp("search").stream().map(e -> GSONP.getStr(e, "title"))));
        }
        return l;
    }

    public ArrayList<PageSection> splitPageByHeader(String title) {
        this.conf.log.info(this, "Splitting " + title + " by header");
        try {
            return PageSection.pageBySection(GSONP.getJAofJO(GSONP.getNestedJA(JsonParser.parseString((String)this.basicGET("parse", "prop", "sections", "page", title).body().string()).getAsJsonObject(), FL.toSAL("parse", "sections"))), this.getPageText(title));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ArrayList<PageSection>();
        }
    }

    public ArrayList<String> whatLinksHere(String title, boolean redirects) {
        this.conf.log.info(this, "Getting links to " + title);
        return MQuery.linksHere(this, redirects, FL.toSAL(title)).get(title);
    }

    public ArrayList<String> whatLinksHere(String title) {
        return this.whatLinksHere(title, false);
    }

    public ArrayList<String> whatTranscludesHere(String title, NS ... ns) {
        this.conf.log.info(this, "Getting list of pages that transclude " + title);
        return MQuery.transcludesIn(this, FL.toSAL(title), ns).get(title);
    }

    public static class Builder {
        private Wiki wiki = new Wiki();
        private Proxy proxy;
        private String username;
        private String password;

        public Builder withUserAgent(String userAgent) {
            this.wiki.conf.userAgent = userAgent;
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withApiEndpoint(HttpUrl apiEndpoint) {
            this.wiki.conf.retarget(apiEndpoint);
            return this;
        }

        public Builder withDomain(String domain) {
            return this.withApiEndpoint(HttpUrl.parse((String)String.format("https://%s/w/api.php", domain)));
        }

        public Builder withDefaultLogger(boolean enableLogging) {
            this.wiki.conf.log.enabled = enableLogging;
            return this;
        }

        public Builder withLogin(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder withDebug(boolean enableDebug) {
            this.wiki.debug = enableDebug;
            return this;
        }

        public Wiki build() {
            this.wiki.apiclient = new ApiClient(this.wiki, this.proxy);
            if (this.username != null && this.password != null && !this.wiki.login(this.username, this.password)) {
                throw new SecurityException(String.format("Failed to log-in as %s @ %s", this.username, this.wiki.conf.hostname));
            }
            this.wiki.refreshNS();
            return this.wiki;
        }
    }
}

