/*
 * Decompiled with CFR 0.152.
 */
package io.github.fastily.jwiki.util;

import io.github.fastily.jwiki.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class FL {
    private FL() {
    }

    public static <T1> ArrayList<T1> toAL(Stream<T1> s) {
        return s.collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T1> HashSet<T1> toSet(Stream<T1> s) {
        return s.collect(Collectors.toCollection(HashSet::new));
    }

    public static <K, V, T1> HashMap<K, V> toHM(Stream<T1> s, Function<T1, K> keyMapper, Function<T1, V> valueMapper) {
        return new HashMap<K, V>(s.collect(Collectors.toMap(keyMapper, valueMapper, (oVal, nVal) -> nVal)));
    }

    public static ArrayList<String> toSAL(String ... strings) {
        return new ArrayList<String>(Arrays.asList(strings));
    }

    public static HashSet<String> toSHS(String ... strings) {
        return new HashSet<String>(Arrays.asList(strings));
    }

    public static <T1, T2> ArrayList<Tuple<T1, T2>> mapToList(Map<T1, T2> h) {
        return FL.toAL(h.entrySet().stream().map(e -> new Tuple(e.getKey(), e.getValue())));
    }

    public static HashMap<String, String> pMap(String ... sl) {
        if (sl.length % 2 == 1) {
            throw new IllegalArgumentException("pMap() cannot work with an odd number of entries!");
        }
        HashMap<String, String> l = new HashMap<String, String>();
        for (int i = 0; i < sl.length; i += 2) {
            l.put(sl[i], sl[i + 1]);
        }
        return l;
    }

    public static <T> Stream<T> streamFrom(Iterable<T> i) {
        return StreamSupport.stream(i.spliterator(), false);
    }

    public static String pipeFence(Collection<String> planks) {
        return String.join((CharSequence)"|", planks);
    }

    public static <T> boolean containsNull(Collection<T> l) {
        return l.stream().anyMatch(o -> o == null);
    }
}

