/*
 * Decompiled with CFR 0.152.
 */
package io.github.felixgilioli.felixutils.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<T> condition) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(condition);
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return collection.stream().filter(condition).collect(Collectors.toList());
    }

    public static <T, S> List<T> map(Collection<S> collection, Function<S, T> mapper) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(mapper);
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return collection.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T> Optional<T> findFirst(Collection<T> collection, Predicate<T> condition) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(condition);
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        return collection.stream().filter(condition).findFirst();
    }
}

