/*
 * Decompiled with CFR 0.152.
 */
package io.github.felixgilioli.felixutils.objects;

import java.util.Objects;
import java.util.function.Predicate;

public class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> T checkArgument(T obj, Predicate<T> condition) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(condition);
        if (!condition.test(obj)) {
            throw new IllegalArgumentException();
        }
        return obj;
    }

    public static <T> T checkArgument(T obj, Predicate<T> condition, String message) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(obj, message);
        Objects.requireNonNull(condition);
        if (condition.test(obj)) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }
}

