/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.core;

import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import okhttp3.Interceptor;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private static final Duration ONE_SECOND = Duration.ofSeconds(1L);
    private final ExponentialBackoff backoff;
    private final Random random = new Random();

    public RetryInterceptor(int maxRetries) {
        this.backoff = new ExponentialBackoff(maxRetries);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (RetryInterceptor.shouldRetry(response.code())) {
            return this.retryChain(chain);
        }
        return response;
    }

    private Response retryChain(Interceptor.Chain chain) throws IOException {
        Optional<Duration> nextBackoff = this.backoff.nextBackoff();
        while (nextBackoff.isPresent()) {
            try {
                Thread.sleep(nextBackoff.get().toMillis());
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while trying request", e);
            }
            Response response = chain.proceed(chain.request());
            if (RetryInterceptor.shouldRetry(response.code())) {
                nextBackoff = this.backoff.nextBackoff();
                continue;
            }
            return response;
        }
        throw new IOException("Max retries reached");
    }

    private static boolean shouldRetry(int statusCode) {
        return statusCode == 408 || statusCode == 409 || statusCode == 429 || statusCode >= 500;
    }

    private final class ExponentialBackoff {
        private final int maxNumRetries;
        private int retryNumber = 0;

        ExponentialBackoff(int maxNumRetries) {
            this.maxNumRetries = maxNumRetries;
        }

        public Optional<Duration> nextBackoff() {
            ++this.retryNumber;
            if (this.retryNumber > this.maxNumRetries) {
                return Optional.empty();
            }
            int upperBound = (int)Math.pow(2.0, this.retryNumber);
            return Optional.of(ONE_SECOND.multipliedBy(RetryInterceptor.this.random.nextInt(upperBound)));
        }
    }
}

