/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatConnector;
import com.cohere.api.types.ChatDocument;
import com.cohere.api.types.ChatMessage;
import com.cohere.api.types.ChatRequestCitationQuality;
import com.cohere.api.types.ChatRequestPromptTruncation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatRequest {
    private final String message;
    private final Optional<String> model;
    private final Optional<String> preambleOverride;
    private final Optional<List<ChatMessage>> chatHistory;
    private final Optional<String> conversationId;
    private final Optional<ChatRequestPromptTruncation> promptTruncation;
    private final Optional<List<ChatConnector>> connectors;
    private final Optional<Boolean> searchQueriesOnly;
    private final Optional<List<ChatDocument>> documents;
    private final Optional<ChatRequestCitationQuality> citationQuality;
    private final Optional<Double> temperature;

    private ChatRequest(String message, Optional<String> model, Optional<String> preambleOverride, Optional<List<ChatMessage>> chatHistory, Optional<String> conversationId, Optional<ChatRequestPromptTruncation> promptTruncation, Optional<List<ChatConnector>> connectors, Optional<Boolean> searchQueriesOnly, Optional<List<ChatDocument>> documents, Optional<ChatRequestCitationQuality> citationQuality, Optional<Double> temperature) {
        this.message = message;
        this.model = model;
        this.preambleOverride = preambleOverride;
        this.chatHistory = chatHistory;
        this.conversationId = conversationId;
        this.promptTruncation = promptTruncation;
        this.connectors = connectors;
        this.searchQueriesOnly = searchQueriesOnly;
        this.documents = documents;
        this.citationQuality = citationQuality;
        this.temperature = temperature;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="preamble_override")
    public Optional<String> getPreambleOverride() {
        return this.preambleOverride;
    }

    @JsonProperty(value="chat_history")
    public Optional<List<ChatMessage>> getChatHistory() {
        return this.chatHistory;
    }

    @JsonProperty(value="conversation_id")
    public Optional<String> getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="prompt_truncation")
    public Optional<ChatRequestPromptTruncation> getPromptTruncation() {
        return this.promptTruncation;
    }

    @JsonProperty(value="connectors")
    public Optional<List<ChatConnector>> getConnectors() {
        return this.connectors;
    }

    @JsonProperty(value="search_queries_only")
    public Optional<Boolean> getSearchQueriesOnly() {
        return this.searchQueriesOnly;
    }

    @JsonProperty(value="documents")
    public Optional<List<ChatDocument>> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="citation_quality")
    public Optional<ChatRequestCitationQuality> getCitationQuality() {
        return this.citationQuality;
    }

    @JsonProperty(value="temperature")
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatRequest && this.equalTo((ChatRequest)other);
    }

    private boolean equalTo(ChatRequest other) {
        return this.message.equals(other.message) && this.model.equals(other.model) && this.preambleOverride.equals(other.preambleOverride) && this.chatHistory.equals(other.chatHistory) && this.conversationId.equals(other.conversationId) && this.promptTruncation.equals(other.promptTruncation) && this.connectors.equals(other.connectors) && this.searchQueriesOnly.equals(other.searchQueriesOnly) && this.documents.equals(other.documents) && this.citationQuality.equals(other.citationQuality) && this.temperature.equals(other.temperature);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.model, this.preambleOverride, this.chatHistory, this.conversationId, this.promptTruncation, this.connectors, this.searchQueriesOnly, this.documents, this.citationQuality, this.temperature);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageStage,
    _FinalStage {
        private String message;
        private Optional<Double> temperature = Optional.empty();
        private Optional<ChatRequestCitationQuality> citationQuality = Optional.empty();
        private Optional<List<ChatDocument>> documents = Optional.empty();
        private Optional<Boolean> searchQueriesOnly = Optional.empty();
        private Optional<List<ChatConnector>> connectors = Optional.empty();
        private Optional<ChatRequestPromptTruncation> promptTruncation = Optional.empty();
        private Optional<String> conversationId = Optional.empty();
        private Optional<List<ChatMessage>> chatHistory = Optional.empty();
        private Optional<String> preambleOverride = Optional.empty();
        private Optional<Boolean> stream = Optional.empty();
        private Optional<String> model = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ChatRequest other) {
            this.message(other.getMessage());
            this.model(other.getModel());
            this.preambleOverride(other.getPreambleOverride());
            this.chatHistory(other.getChatHistory());
            this.conversationId(other.getConversationId());
            this.promptTruncation(other.getPromptTruncation());
            this.connectors(other.getConnectors());
            this.searchQueriesOnly(other.getSearchQueriesOnly());
            this.documents(other.getDocuments());
            this.citationQuality(other.getCitationQuality());
            this.temperature(other.getTemperature());
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage citationQuality(ChatRequestCitationQuality citationQuality) {
            this.citationQuality = Optional.of(citationQuality);
            return this;
        }

        @Override
        @JsonSetter(value="citation_quality", nulls=Nulls.SKIP)
        public _FinalStage citationQuality(Optional<ChatRequestCitationQuality> citationQuality) {
            this.citationQuality = citationQuality;
            return this;
        }

        @Override
        public _FinalStage documents(List<ChatDocument> documents) {
            this.documents = Optional.of(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(Optional<List<ChatDocument>> documents) {
            this.documents = documents;
            return this;
        }

        @Override
        public _FinalStage searchQueriesOnly(Boolean searchQueriesOnly) {
            this.searchQueriesOnly = Optional.of(searchQueriesOnly);
            return this;
        }

        @Override
        @JsonSetter(value="search_queries_only", nulls=Nulls.SKIP)
        public _FinalStage searchQueriesOnly(Optional<Boolean> searchQueriesOnly) {
            this.searchQueriesOnly = searchQueriesOnly;
            return this;
        }

        @Override
        public _FinalStage connectors(List<ChatConnector> connectors) {
            this.connectors = Optional.of(connectors);
            return this;
        }

        @Override
        @JsonSetter(value="connectors", nulls=Nulls.SKIP)
        public _FinalStage connectors(Optional<List<ChatConnector>> connectors) {
            this.connectors = connectors;
            return this;
        }

        @Override
        public _FinalStage promptTruncation(ChatRequestPromptTruncation promptTruncation) {
            this.promptTruncation = Optional.of(promptTruncation);
            return this;
        }

        @Override
        @JsonSetter(value="prompt_truncation", nulls=Nulls.SKIP)
        public _FinalStage promptTruncation(Optional<ChatRequestPromptTruncation> promptTruncation) {
            this.promptTruncation = promptTruncation;
            return this;
        }

        @Override
        public _FinalStage conversationId(String conversationId) {
            this.conversationId = Optional.of(conversationId);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id", nulls=Nulls.SKIP)
        public _FinalStage conversationId(Optional<String> conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @Override
        public _FinalStage chatHistory(List<ChatMessage> chatHistory) {
            this.chatHistory = Optional.of(chatHistory);
            return this;
        }

        @Override
        @JsonSetter(value="chat_history", nulls=Nulls.SKIP)
        public _FinalStage chatHistory(Optional<List<ChatMessage>> chatHistory) {
            this.chatHistory = chatHistory;
            return this;
        }

        @Override
        public _FinalStage preambleOverride(String preambleOverride) {
            this.preambleOverride = Optional.of(preambleOverride);
            return this;
        }

        @Override
        @JsonSetter(value="preamble_override", nulls=Nulls.SKIP)
        public _FinalStage preambleOverride(Optional<String> preambleOverride) {
            this.preambleOverride = preambleOverride;
            return this;
        }

        @Override
        public _FinalStage stream(Boolean stream) {
            this.stream = Optional.of(stream);
            return this;
        }

        @Override
        @JsonSetter(value="stream", nulls=Nulls.SKIP)
        public _FinalStage stream(Optional<Boolean> stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public ChatRequest build() {
            return new ChatRequest(this.message, this.model, this.preambleOverride, this.chatHistory, this.conversationId, this.promptTruncation, this.connectors, this.searchQueriesOnly, this.documents, this.citationQuality, this.temperature);
        }
    }

    public static interface _FinalStage {
        public ChatRequest build();

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage stream(Optional<Boolean> var1);

        public _FinalStage stream(Boolean var1);

        public _FinalStage preambleOverride(Optional<String> var1);

        public _FinalStage preambleOverride(String var1);

        public _FinalStage chatHistory(Optional<List<ChatMessage>> var1);

        public _FinalStage chatHistory(List<ChatMessage> var1);

        public _FinalStage conversationId(Optional<String> var1);

        public _FinalStage conversationId(String var1);

        public _FinalStage promptTruncation(Optional<ChatRequestPromptTruncation> var1);

        public _FinalStage promptTruncation(ChatRequestPromptTruncation var1);

        public _FinalStage connectors(Optional<List<ChatConnector>> var1);

        public _FinalStage connectors(List<ChatConnector> var1);

        public _FinalStage searchQueriesOnly(Optional<Boolean> var1);

        public _FinalStage searchQueriesOnly(Boolean var1);

        public _FinalStage documents(Optional<List<ChatDocument>> var1);

        public _FinalStage documents(List<ChatDocument> var1);

        public _FinalStage citationQuality(Optional<ChatRequestCitationQuality> var1);

        public _FinalStage citationQuality(ChatRequestCitationQuality var1);

        public _FinalStage temperature(Optional<Double> var1);

        public _FinalStage temperature(Double var1);
    }

    public static interface MessageStage {
        public _FinalStage message(String var1);

        public Builder from(ChatRequest var1);
    }
}

