/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DetokenizeRequest {
    private final List<Integer> tokens;
    private final Optional<String> model;

    private DetokenizeRequest(List<Integer> tokens, Optional<String> model) {
        this.tokens = tokens;
        this.model = model;
    }

    @JsonProperty(value="tokens")
    public List<Integer> getTokens() {
        return this.tokens;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DetokenizeRequest && this.equalTo((DetokenizeRequest)other);
    }

    private boolean equalTo(DetokenizeRequest other) {
        return this.tokens.equals(other.tokens) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.tokens, this.model);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Integer> tokens = new ArrayList<Integer>();
        private Optional<String> model = Optional.empty();

        private Builder() {
        }

        public Builder from(DetokenizeRequest other) {
            this.tokens(other.getTokens());
            this.model(other.getModel());
            return this;
        }

        @JsonSetter(value="tokens", nulls=Nulls.SKIP)
        public Builder tokens(List<Integer> tokens) {
            this.tokens.clear();
            this.tokens.addAll(tokens);
            return this;
        }

        public Builder addTokens(Integer tokens) {
            this.tokens.add(tokens);
            return this;
        }

        public Builder addAllTokens(List<Integer> tokens) {
            this.tokens.addAll(tokens);
            return this;
        }

        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public Builder model(Optional<String> model) {
            this.model = model;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        public DetokenizeRequest build() {
            return new DetokenizeRequest(this.tokens, this.model);
        }
    }
}

