/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.EmbedRequestTruncate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class EmbedRequest {
    private final List<String> texts;
    private final Optional<String> model;
    private final Optional<EmbedRequestTruncate> truncate;

    private EmbedRequest(List<String> texts, Optional<String> model, Optional<EmbedRequestTruncate> truncate) {
        this.texts = texts;
        this.model = model;
        this.truncate = truncate;
    }

    @JsonProperty(value="texts")
    public List<String> getTexts() {
        return this.texts;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="truncate")
    public Optional<EmbedRequestTruncate> getTruncate() {
        return this.truncate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedRequest && this.equalTo((EmbedRequest)other);
    }

    private boolean equalTo(EmbedRequest other) {
        return this.texts.equals(other.texts) && this.model.equals(other.model) && this.truncate.equals(other.truncate);
    }

    public int hashCode() {
        return Objects.hash(this.texts, this.model, this.truncate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> texts = new ArrayList<String>();
        private Optional<String> model = Optional.empty();
        private Optional<EmbedRequestTruncate> truncate = Optional.empty();

        private Builder() {
        }

        public Builder from(EmbedRequest other) {
            this.texts(other.getTexts());
            this.model(other.getModel());
            this.truncate(other.getTruncate());
            return this;
        }

        @JsonSetter(value="texts", nulls=Nulls.SKIP)
        public Builder texts(List<String> texts) {
            this.texts.clear();
            this.texts.addAll(texts);
            return this;
        }

        public Builder addTexts(String texts) {
            this.texts.add(texts);
            return this;
        }

        public Builder addAllTexts(List<String> texts) {
            this.texts.addAll(texts);
            return this;
        }

        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public Builder model(Optional<String> model) {
            this.model = model;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public Builder truncate(Optional<EmbedRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        public Builder truncate(EmbedRequestTruncate truncate) {
            this.truncate = Optional.of(truncate);
            return this;
        }

        public EmbedRequest build() {
            return new EmbedRequest(this.texts, this.model, this.truncate);
        }
    }
}

