/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.SummarizeRequestExtractiveness;
import com.cohere.api.types.SummarizeRequestFormat;
import com.cohere.api.types.SummarizeRequestLength;
import com.cohere.api.types.SummarizeRequestModel;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SummarizeRequest {
    private final String text;
    private final Optional<SummarizeRequestLength> length;
    private final Optional<SummarizeRequestFormat> format;
    private final Optional<SummarizeRequestModel> model;
    private final Optional<SummarizeRequestExtractiveness> extractiveness;
    private final Optional<Double> temperature;
    private final Optional<String> additionalCommand;

    private SummarizeRequest(String text, Optional<SummarizeRequestLength> length, Optional<SummarizeRequestFormat> format, Optional<SummarizeRequestModel> model, Optional<SummarizeRequestExtractiveness> extractiveness, Optional<Double> temperature, Optional<String> additionalCommand) {
        this.text = text;
        this.length = length;
        this.format = format;
        this.model = model;
        this.extractiveness = extractiveness;
        this.temperature = temperature;
        this.additionalCommand = additionalCommand;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="length")
    public Optional<SummarizeRequestLength> getLength() {
        return this.length;
    }

    @JsonProperty(value="format")
    public Optional<SummarizeRequestFormat> getFormat() {
        return this.format;
    }

    @JsonProperty(value="model")
    public Optional<SummarizeRequestModel> getModel() {
        return this.model;
    }

    @JsonProperty(value="extractiveness")
    public Optional<SummarizeRequestExtractiveness> getExtractiveness() {
        return this.extractiveness;
    }

    @JsonProperty(value="temperature")
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="additional_command")
    public Optional<String> getAdditionalCommand() {
        return this.additionalCommand;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SummarizeRequest && this.equalTo((SummarizeRequest)other);
    }

    private boolean equalTo(SummarizeRequest other) {
        return this.text.equals(other.text) && this.length.equals(other.length) && this.format.equals(other.format) && this.model.equals(other.model) && this.extractiveness.equals(other.extractiveness) && this.temperature.equals(other.temperature) && this.additionalCommand.equals(other.additionalCommand);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.length, this.format, this.model, this.extractiveness, this.temperature, this.additionalCommand);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    _FinalStage {
        private String text;
        private Optional<String> additionalCommand = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<SummarizeRequestExtractiveness> extractiveness = Optional.empty();
        private Optional<SummarizeRequestModel> model = Optional.empty();
        private Optional<SummarizeRequestFormat> format = Optional.empty();
        private Optional<SummarizeRequestLength> length = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(SummarizeRequest other) {
            this.text(other.getText());
            this.length(other.getLength());
            this.format(other.getFormat());
            this.model(other.getModel());
            this.extractiveness(other.getExtractiveness());
            this.temperature(other.getTemperature());
            this.additionalCommand(other.getAdditionalCommand());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage additionalCommand(String additionalCommand) {
            this.additionalCommand = Optional.of(additionalCommand);
            return this;
        }

        @Override
        @JsonSetter(value="additional_command", nulls=Nulls.SKIP)
        public _FinalStage additionalCommand(Optional<String> additionalCommand) {
            this.additionalCommand = additionalCommand;
            return this;
        }

        @Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage extractiveness(SummarizeRequestExtractiveness extractiveness) {
            this.extractiveness = Optional.of(extractiveness);
            return this;
        }

        @Override
        @JsonSetter(value="extractiveness", nulls=Nulls.SKIP)
        public _FinalStage extractiveness(Optional<SummarizeRequestExtractiveness> extractiveness) {
            this.extractiveness = extractiveness;
            return this;
        }

        @Override
        public _FinalStage model(SummarizeRequestModel model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<SummarizeRequestModel> model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage format(SummarizeRequestFormat format) {
            this.format = Optional.of(format);
            return this;
        }

        @Override
        @JsonSetter(value="format", nulls=Nulls.SKIP)
        public _FinalStage format(Optional<SummarizeRequestFormat> format) {
            this.format = format;
            return this;
        }

        @Override
        public _FinalStage length(SummarizeRequestLength length) {
            this.length = Optional.of(length);
            return this;
        }

        @Override
        @JsonSetter(value="length", nulls=Nulls.SKIP)
        public _FinalStage length(Optional<SummarizeRequestLength> length) {
            this.length = length;
            return this;
        }

        @Override
        public SummarizeRequest build() {
            return new SummarizeRequest(this.text, this.length, this.format, this.model, this.extractiveness, this.temperature, this.additionalCommand);
        }
    }

    public static interface _FinalStage {
        public SummarizeRequest build();

        public _FinalStage length(Optional<SummarizeRequestLength> var1);

        public _FinalStage length(SummarizeRequestLength var1);

        public _FinalStage format(Optional<SummarizeRequestFormat> var1);

        public _FinalStage format(SummarizeRequestFormat var1);

        public _FinalStage model(Optional<SummarizeRequestModel> var1);

        public _FinalStage model(SummarizeRequestModel var1);

        public _FinalStage extractiveness(Optional<SummarizeRequestExtractiveness> var1);

        public _FinalStage extractiveness(SummarizeRequestExtractiveness var1);

        public _FinalStage temperature(Optional<Double> var1);

        public _FinalStage temperature(Double var1);

        public _FinalStage additionalCommand(Optional<String> var1);

        public _FinalStage additionalCommand(String var1);
    }

    public static interface TextStage {
        public _FinalStage text(String var1);

        public Builder from(SummarizeRequest var1);
    }
}

