/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TokenizeRequest {
    private final String text;
    private final Optional<String> model;

    private TokenizeRequest(String text, Optional<String> model) {
        this.text = text;
        this.model = model;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TokenizeRequest && this.equalTo((TokenizeRequest)other);
    }

    private boolean equalTo(TokenizeRequest other) {
        return this.text.equals(other.text) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.model);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    _FinalStage {
        private String text;
        private Optional<String> model = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(TokenizeRequest other) {
            this.text(other.getText());
            this.model(other.getModel());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public TokenizeRequest build() {
            return new TokenizeRequest(this.text, this.model);
        }
    }

    public static interface _FinalStage {
        public TokenizeRequest build();

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);
    }

    public static interface TextStage {
        public _FinalStage text(String var1);

        public Builder from(TokenizeRequest var1);
    }
}

