/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMetaApiVersion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ApiMeta {
    private final Optional<ApiMetaApiVersion> apiVersion;
    private final Optional<List<String>> warnings;

    private ApiMeta(Optional<ApiMetaApiVersion> apiVersion, Optional<List<String>> warnings) {
        this.apiVersion = apiVersion;
        this.warnings = warnings;
    }

    @JsonProperty(value="api_version")
    public Optional<ApiMetaApiVersion> getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="warnings")
    public Optional<List<String>> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiMeta && this.equalTo((ApiMeta)other);
    }

    private boolean equalTo(ApiMeta other) {
        return this.apiVersion.equals(other.apiVersion) && this.warnings.equals(other.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.warnings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ApiMetaApiVersion> apiVersion = Optional.empty();
        private Optional<List<String>> warnings = Optional.empty();

        private Builder() {
        }

        public Builder from(ApiMeta other) {
            this.apiVersion(other.getApiVersion());
            this.warnings(other.getWarnings());
            return this;
        }

        @JsonSetter(value="api_version", nulls=Nulls.SKIP)
        public Builder apiVersion(Optional<ApiMetaApiVersion> apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(ApiMetaApiVersion apiVersion) {
            this.apiVersion = Optional.of(apiVersion);
            return this;
        }

        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public Builder warnings(Optional<List<String>> warnings) {
            this.warnings = warnings;
            return this;
        }

        public Builder warnings(List<String> warnings) {
            this.warnings = Optional.of(warnings);
            return this;
        }

        public ApiMeta build() {
            return new ApiMeta(this.apiVersion, this.warnings);
        }
    }
}

