/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatCitation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatCitationGenerationEvent {
    private final List<ChatCitation> citations;

    private ChatCitationGenerationEvent(List<ChatCitation> citations) {
        this.citations = citations;
    }

    @JsonProperty(value="citations")
    public List<ChatCitation> getCitations() {
        return this.citations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatCitationGenerationEvent && this.equalTo((ChatCitationGenerationEvent)other);
    }

    private boolean equalTo(ChatCitationGenerationEvent other) {
        return this.citations.equals(other.citations);
    }

    public int hashCode() {
        return Objects.hash(this.citations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<ChatCitation> citations = new ArrayList<ChatCitation>();

        private Builder() {
        }

        public Builder from(ChatCitationGenerationEvent other) {
            this.citations(other.getCitations());
            return this;
        }

        @JsonSetter(value="citations", nulls=Nulls.SKIP)
        public Builder citations(List<ChatCitation> citations) {
            this.citations.clear();
            this.citations.addAll(citations);
            return this;
        }

        public Builder addCitations(ChatCitation citations) {
            this.citations.add(citations);
            return this;
        }

        public Builder addAllCitations(List<ChatCitation> citations) {
            this.citations.addAll(citations);
            return this;
        }

        public ChatCitationGenerationEvent build() {
            return new ChatCitationGenerationEvent(this.citations);
        }
    }
}

