/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatConnector {
    private final String id;
    private final Optional<Map<String, Object>> options;

    private ChatConnector(String id, Optional<Map<String, Object>> options) {
        this.id = id;
        this.options = options;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="options")
    public Optional<Map<String, Object>> getOptions() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatConnector && this.equalTo((ChatConnector)other);
    }

    private boolean equalTo(ChatConnector other) {
        return this.id.equals(other.id) && this.options.equals(other.options);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.options);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<Map<String, Object>> options = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ChatConnector other) {
            this.id(other.getId());
            this.options(other.getOptions());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage options(Map<String, Object> options) {
            this.options = Optional.of(options);
            return this;
        }

        @Override
        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public _FinalStage options(Optional<Map<String, Object>> options) {
            this.options = options;
            return this;
        }

        @Override
        public ChatConnector build() {
            return new ChatConnector(this.id, this.options);
        }
    }

    public static interface _FinalStage {
        public ChatConnector build();

        public _FinalStage options(Optional<Map<String, Object>> var1);

        public _FinalStage options(Map<String, Object> var1);
    }

    public static interface IdStage {
        public _FinalStage id(String var1);

        public Builder from(ChatConnector var1);
    }
}

