/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatMessageRole;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatMessage {
    private final ChatMessageRole role;
    private final String message;
    private final Optional<String> userName;

    private ChatMessage(ChatMessageRole role, String message, Optional<String> userName) {
        this.role = role;
        this.message = message;
        this.userName = userName;
    }

    @JsonProperty(value="role")
    public ChatMessageRole getRole() {
        return this.role;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="user_name")
    public Optional<String> getUserName() {
        return this.userName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatMessage && this.equalTo((ChatMessage)other);
    }

    private boolean equalTo(ChatMessage other) {
        return this.role.equals((Object)other.role) && this.message.equals(other.message) && this.userName.equals(other.userName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.message, this.userName});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RoleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RoleStage,
    MessageStage,
    _FinalStage {
        private ChatMessageRole role;
        private String message;
        private Optional<String> userName = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ChatMessage other) {
            this.role(other.getRole());
            this.message(other.getMessage());
            this.userName(other.getUserName());
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public MessageStage role(ChatMessageRole role) {
            this.role = role;
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage userName(String userName) {
            this.userName = Optional.of(userName);
            return this;
        }

        @Override
        @JsonSetter(value="user_name", nulls=Nulls.SKIP)
        public _FinalStage userName(Optional<String> userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public ChatMessage build() {
            return new ChatMessage(this.role, this.message, this.userName);
        }
    }

    public static interface _FinalStage {
        public ChatMessage build();

        public _FinalStage userName(Optional<String> var1);

        public _FinalStage userName(String var1);
    }

    public static interface MessageStage {
        public _FinalStage message(String var1);
    }

    public static interface RoleStage {
        public MessageStage role(ChatMessageRole var1);

        public Builder from(ChatMessage var1);
    }
}

