/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.NonStreamedChatResponse;
import com.cohere.api.types.SearchQueriesOnlyResponse;
import com.cohere.api.types.StreamedChatResponse;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class ChatResponse {
    private final Object value;
    private final int type;

    private ChatResponse(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((NonStreamedChatResponse)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((StreamedChatResponse)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((SearchQueriesOnlyResponse)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatResponse && this.equalTo((ChatResponse)other);
    }

    private boolean equalTo(ChatResponse other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ChatResponse of(NonStreamedChatResponse value) {
        return new ChatResponse(value, 0);
    }

    public static ChatResponse of(StreamedChatResponse value) {
        return new ChatResponse(value, 1);
    }

    public static ChatResponse of(SearchQueriesOnlyResponse value) {
        return new ChatResponse(value, 2);
    }

    static final class Deserializer
    extends StdDeserializer<ChatResponse> {
        Deserializer() {
            super(ChatResponse.class);
        }

        public ChatResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ChatResponse.of((NonStreamedChatResponse)ObjectMappers.JSON_MAPPER.convertValue(value, NonStreamedChatResponse.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ChatResponse.of((StreamedChatResponse)ObjectMappers.JSON_MAPPER.convertValue(value, StreamedChatResponse.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return ChatResponse.of((SearchQueriesOnlyResponse)ObjectMappers.JSON_MAPPER.convertValue(value, SearchQueriesOnlyResponse.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(NonStreamedChatResponse var1);

        public T visit(StreamedChatResponse var1);

        public T visit(SearchQueriesOnlyResponse var1);
    }
}

