/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatConnector;
import com.cohere.api.types.ChatSearchQuery;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatSearchResult {
    private final ChatSearchQuery searchQuery;
    private final ChatConnector connector;
    private final List<String> documentIds;

    private ChatSearchResult(ChatSearchQuery searchQuery, ChatConnector connector, List<String> documentIds) {
        this.searchQuery = searchQuery;
        this.connector = connector;
        this.documentIds = documentIds;
    }

    @JsonProperty(value="search_query")
    public ChatSearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    @JsonProperty(value="connector")
    public ChatConnector getConnector() {
        return this.connector;
    }

    @JsonProperty(value="document_ids")
    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatSearchResult && this.equalTo((ChatSearchResult)other);
    }

    private boolean equalTo(ChatSearchResult other) {
        return this.searchQuery.equals(other.searchQuery) && this.connector.equals(other.connector) && this.documentIds.equals(other.documentIds);
    }

    public int hashCode() {
        return Objects.hash(this.searchQuery, this.connector, this.documentIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SearchQueryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SearchQueryStage,
    ConnectorStage,
    _FinalStage {
        private ChatSearchQuery searchQuery;
        private ChatConnector connector;
        private List<String> documentIds = new ArrayList<String>();

        private Builder() {
        }

        @Override
        public Builder from(ChatSearchResult other) {
            this.searchQuery(other.getSearchQuery());
            this.connector(other.getConnector());
            this.documentIds(other.getDocumentIds());
            return this;
        }

        @Override
        @JsonSetter(value="search_query")
        public ConnectorStage searchQuery(ChatSearchQuery searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        @Override
        @JsonSetter(value="connector")
        public _FinalStage connector(ChatConnector connector) {
            this.connector = connector;
            return this;
        }

        @Override
        public _FinalStage addAllDocumentIds(List<String> documentIds) {
            this.documentIds.addAll(documentIds);
            return this;
        }

        @Override
        public _FinalStage addDocumentIds(String documentIds) {
            this.documentIds.add(documentIds);
            return this;
        }

        @Override
        @JsonSetter(value="document_ids", nulls=Nulls.SKIP)
        public _FinalStage documentIds(List<String> documentIds) {
            this.documentIds.clear();
            this.documentIds.addAll(documentIds);
            return this;
        }

        @Override
        public ChatSearchResult build() {
            return new ChatSearchResult(this.searchQuery, this.connector, this.documentIds);
        }
    }

    public static interface _FinalStage {
        public ChatSearchResult build();

        public _FinalStage documentIds(List<String> var1);

        public _FinalStage addDocumentIds(String var1);

        public _FinalStage addAllDocumentIds(List<String> var1);
    }

    public static interface ConnectorStage {
        public _FinalStage connector(ChatConnector var1);
    }

    public static interface SearchQueryStage {
        public ConnectorStage searchQuery(ChatSearchQuery var1);

        public Builder from(ChatSearchResult var1);
    }
}

