/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatDocument;
import com.cohere.api.types.ChatSearchResult;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatSearchResultsEvent {
    private final List<ChatSearchResult> searchResults;
    private final List<ChatDocument> documents;

    private ChatSearchResultsEvent(List<ChatSearchResult> searchResults, List<ChatDocument> documents) {
        this.searchResults = searchResults;
        this.documents = documents;
    }

    @JsonProperty(value="search_results")
    public List<ChatSearchResult> getSearchResults() {
        return this.searchResults;
    }

    @JsonProperty(value="documents")
    public List<ChatDocument> getDocuments() {
        return this.documents;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatSearchResultsEvent && this.equalTo((ChatSearchResultsEvent)other);
    }

    private boolean equalTo(ChatSearchResultsEvent other) {
        return this.searchResults.equals(other.searchResults) && this.documents.equals(other.documents);
    }

    public int hashCode() {
        return Objects.hash(this.searchResults, this.documents);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<ChatSearchResult> searchResults = new ArrayList<ChatSearchResult>();
        private List<ChatDocument> documents = new ArrayList<ChatDocument>();

        private Builder() {
        }

        public Builder from(ChatSearchResultsEvent other) {
            this.searchResults(other.getSearchResults());
            this.documents(other.getDocuments());
            return this;
        }

        @JsonSetter(value="search_results", nulls=Nulls.SKIP)
        public Builder searchResults(List<ChatSearchResult> searchResults) {
            this.searchResults.clear();
            this.searchResults.addAll(searchResults);
            return this;
        }

        public Builder addSearchResults(ChatSearchResult searchResults) {
            this.searchResults.add(searchResults);
            return this;
        }

        public Builder addAllSearchResults(List<ChatSearchResult> searchResults) {
            this.searchResults.addAll(searchResults);
            return this;
        }

        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public Builder documents(List<ChatDocument> documents) {
            this.documents.clear();
            this.documents.addAll(documents);
            return this;
        }

        public Builder addDocuments(ChatDocument documents) {
            this.documents.add(documents);
            return this;
        }

        public Builder addAllDocuments(List<ChatDocument> documents) {
            this.documents.addAll(documents);
            return this;
        }

        public ChatSearchResultsEvent build() {
            return new ChatSearchResultsEvent(this.searchResults, this.documents);
        }
    }
}

