/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.NonStreamedChatResponse;
import com.cohere.api.types.SearchQueriesOnlyResponse;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class ChatStreamEndEventResponse {
    private final Object value;
    private final int type;

    private ChatStreamEndEventResponse(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((NonStreamedChatResponse)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((SearchQueriesOnlyResponse)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatStreamEndEventResponse && this.equalTo((ChatStreamEndEventResponse)other);
    }

    private boolean equalTo(ChatStreamEndEventResponse other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ChatStreamEndEventResponse of(NonStreamedChatResponse value) {
        return new ChatStreamEndEventResponse(value, 0);
    }

    public static ChatStreamEndEventResponse of(SearchQueriesOnlyResponse value) {
        return new ChatStreamEndEventResponse(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<ChatStreamEndEventResponse> {
        Deserializer() {
            super(ChatStreamEndEventResponse.class);
        }

        public ChatStreamEndEventResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ChatStreamEndEventResponse.of((NonStreamedChatResponse)ObjectMappers.JSON_MAPPER.convertValue(value, NonStreamedChatResponse.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ChatStreamEndEventResponse.of((SearchQueriesOnlyResponse)ObjectMappers.JSON_MAPPER.convertValue(value, SearchQueriesOnlyResponse.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(NonStreamedChatResponse var1);

        public T visit(SearchQueriesOnlyResponse var1);
    }
}

