/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClassifyRequestExamplesItem {
    private final Optional<String> text;
    private final Optional<String> label;

    private ClassifyRequestExamplesItem(Optional<String> text, Optional<String> label) {
        this.text = text;
        this.label = label;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return this.label;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClassifyRequestExamplesItem && this.equalTo((ClassifyRequestExamplesItem)other);
    }

    private boolean equalTo(ClassifyRequestExamplesItem other) {
        return this.text.equals(other.text) && this.label.equals(other.label);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.label);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> text = Optional.empty();
        private Optional<String> label = Optional.empty();

        private Builder() {
        }

        public Builder from(ClassifyRequestExamplesItem other) {
            this.text(other.getText());
            this.label(other.getLabel());
            return this;
        }

        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public Builder text(Optional<String> text) {
            this.text = text;
            return this;
        }

        public Builder text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @JsonSetter(value="label", nulls=Nulls.SKIP)
        public Builder label(Optional<String> label) {
            this.label = label;
            return this;
        }

        public Builder label(String label) {
            this.label = Optional.of(label);
            return this;
        }

        public ClassifyRequestExamplesItem build() {
            return new ClassifyRequestExamplesItem(this.text, this.label);
        }
    }
}

