/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ClassifyResponseClassificationsItemLabelsValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClassifyResponseClassificationsItem {
    private final String id;
    private final Optional<String> input;
    private final String prediction;
    private final double confidence;
    private final Map<String, ClassifyResponseClassificationsItemLabelsValue> labels;
    private final Optional<List<Double>> confidences;

    private ClassifyResponseClassificationsItem(String id, Optional<String> input, String prediction, double confidence, Map<String, ClassifyResponseClassificationsItemLabelsValue> labels, Optional<List<Double>> confidences) {
        this.id = id;
        this.input = input;
        this.prediction = prediction;
        this.confidence = confidence;
        this.labels = labels;
        this.confidences = confidences;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="input")
    public Optional<String> getInput() {
        return this.input;
    }

    @JsonProperty(value="prediction")
    public String getPrediction() {
        return this.prediction;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="labels")
    public Map<String, ClassifyResponseClassificationsItemLabelsValue> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="confidences")
    public Optional<List<Double>> getConfidences() {
        return this.confidences;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClassifyResponseClassificationsItem && this.equalTo((ClassifyResponseClassificationsItem)other);
    }

    private boolean equalTo(ClassifyResponseClassificationsItem other) {
        return this.id.equals(other.id) && this.input.equals(other.input) && this.prediction.equals(other.prediction) && this.confidence == other.confidence && this.labels.equals(other.labels) && this.confidences.equals(other.confidences);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.input, this.prediction, this.confidence, this.labels, this.confidences);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    PredictionStage,
    ConfidenceStage,
    _FinalStage {
        private String id;
        private String prediction;
        private double confidence;
        private Optional<List<Double>> confidences = Optional.empty();
        private Map<String, ClassifyResponseClassificationsItemLabelsValue> labels = new LinkedHashMap<String, ClassifyResponseClassificationsItemLabelsValue>();
        private Optional<String> input = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ClassifyResponseClassificationsItem other) {
            this.id(other.getId());
            this.input(other.getInput());
            this.prediction(other.getPrediction());
            this.confidence(other.getConfidence());
            this.labels(other.getLabels());
            this.confidences(other.getConfidences());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PredictionStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="prediction")
        public ConfidenceStage prediction(String prediction) {
            this.prediction = prediction;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public _FinalStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public _FinalStage confidences(List<Double> confidences) {
            this.confidences = Optional.of(confidences);
            return this;
        }

        @Override
        @JsonSetter(value="confidences", nulls=Nulls.SKIP)
        public _FinalStage confidences(Optional<List<Double>> confidences) {
            this.confidences = confidences;
            return this;
        }

        @Override
        public _FinalStage labels(String key, ClassifyResponseClassificationsItemLabelsValue value) {
            this.labels.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllLabels(Map<String, ClassifyResponseClassificationsItemLabelsValue> labels) {
            this.labels.putAll(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Map<String, ClassifyResponseClassificationsItemLabelsValue> labels) {
            this.labels.clear();
            this.labels.putAll(labels);
            return this;
        }

        @Override
        public _FinalStage input(String input) {
            this.input = Optional.of(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<String> input) {
            this.input = input;
            return this;
        }

        @Override
        public ClassifyResponseClassificationsItem build() {
            return new ClassifyResponseClassificationsItem(this.id, this.input, this.prediction, this.confidence, this.labels, this.confidences);
        }
    }

    public static interface _FinalStage {
        public ClassifyResponseClassificationsItem build();

        public _FinalStage input(Optional<String> var1);

        public _FinalStage input(String var1);

        public _FinalStage labels(Map<String, ClassifyResponseClassificationsItemLabelsValue> var1);

        public _FinalStage putAllLabels(Map<String, ClassifyResponseClassificationsItemLabelsValue> var1);

        public _FinalStage labels(String var1, ClassifyResponseClassificationsItemLabelsValue var2);

        public _FinalStage confidences(Optional<List<Double>> var1);

        public _FinalStage confidences(List<Double> var1);
    }

    public static interface ConfidenceStage {
        public _FinalStage confidence(double var1);
    }

    public static interface PredictionStage {
        public ConfidenceStage prediction(String var1);
    }

    public static interface IdStage {
        public PredictionStage id(String var1);

        public Builder from(ClassifyResponseClassificationsItem var1);
    }
}

