/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.DetectLanguageResponseResultsItem;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DetectLanguageResponse {
    private final Optional<List<DetectLanguageResponseResultsItem>> results;
    private final Optional<ApiMeta> meta;

    private DetectLanguageResponse(Optional<List<DetectLanguageResponseResultsItem>> results, Optional<ApiMeta> meta) {
        this.results = results;
        this.meta = meta;
    }

    @JsonProperty(value="results")
    public Optional<List<DetectLanguageResponseResultsItem>> getResults() {
        return this.results;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DetectLanguageResponse && this.equalTo((DetectLanguageResponse)other);
    }

    private boolean equalTo(DetectLanguageResponse other) {
        return this.results.equals(other.results) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.results, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<DetectLanguageResponseResultsItem>> results = Optional.empty();
        private Optional<ApiMeta> meta = Optional.empty();

        private Builder() {
        }

        public Builder from(DetectLanguageResponse other) {
            this.results(other.getResults());
            this.meta(other.getMeta());
            return this;
        }

        @JsonSetter(value="results", nulls=Nulls.SKIP)
        public Builder results(Optional<List<DetectLanguageResponseResultsItem>> results) {
            this.results = results;
            return this;
        }

        public Builder results(List<DetectLanguageResponseResultsItem> results) {
            this.results = Optional.of(results);
            return this;
        }

        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public Builder meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        public Builder meta(ApiMeta meta) {
            this.meta = Optional.of(meta);
            return this;
        }

        public DetectLanguageResponse build() {
            return new DetectLanguageResponse(this.results, this.meta);
        }
    }
}

