/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DetectLanguageResponseResultsItem {
    private final Optional<String> languageName;
    private final Optional<String> languageCode;

    private DetectLanguageResponseResultsItem(Optional<String> languageName, Optional<String> languageCode) {
        this.languageName = languageName;
        this.languageCode = languageCode;
    }

    @JsonProperty(value="language_name")
    public Optional<String> getLanguageName() {
        return this.languageName;
    }

    @JsonProperty(value="language_code")
    public Optional<String> getLanguageCode() {
        return this.languageCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DetectLanguageResponseResultsItem && this.equalTo((DetectLanguageResponseResultsItem)other);
    }

    private boolean equalTo(DetectLanguageResponseResultsItem other) {
        return this.languageName.equals(other.languageName) && this.languageCode.equals(other.languageCode);
    }

    public int hashCode() {
        return Objects.hash(this.languageName, this.languageCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> languageName = Optional.empty();
        private Optional<String> languageCode = Optional.empty();

        private Builder() {
        }

        public Builder from(DetectLanguageResponseResultsItem other) {
            this.languageName(other.getLanguageName());
            this.languageCode(other.getLanguageCode());
            return this;
        }

        @JsonSetter(value="language_name", nulls=Nulls.SKIP)
        public Builder languageName(Optional<String> languageName) {
            this.languageName = languageName;
            return this;
        }

        public Builder languageName(String languageName) {
            this.languageName = Optional.of(languageName);
            return this;
        }

        @JsonSetter(value="language_code", nulls=Nulls.SKIP)
        public Builder languageCode(Optional<String> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = Optional.of(languageCode);
            return this;
        }

        public DetectLanguageResponseResultsItem build() {
            return new DetectLanguageResponseResultsItem(this.languageName, this.languageCode);
        }
    }
}

