/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class EmbedResponse {
    private final String id;
    private final List<List<Double>> embeddings;
    private final List<String> texts;
    private final Optional<ApiMeta> meta;

    private EmbedResponse(String id, List<List<Double>> embeddings, List<String> texts, Optional<ApiMeta> meta) {
        this.id = id;
        this.embeddings = embeddings;
        this.texts = texts;
        this.meta = meta;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="embeddings")
    public List<List<Double>> getEmbeddings() {
        return this.embeddings;
    }

    @JsonProperty(value="texts")
    public List<String> getTexts() {
        return this.texts;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedResponse && this.equalTo((EmbedResponse)other);
    }

    private boolean equalTo(EmbedResponse other) {
        return this.id.equals(other.id) && this.embeddings.equals(other.embeddings) && this.texts.equals(other.texts) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.embeddings, this.texts, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<ApiMeta> meta = Optional.empty();
        private List<String> texts = new ArrayList<String>();
        private List<List<Double>> embeddings = new ArrayList<List<Double>>();

        private Builder() {
        }

        @Override
        public Builder from(EmbedResponse other) {
            this.id(other.getId());
            this.embeddings(other.getEmbeddings());
            this.texts(other.getTexts());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage meta(ApiMeta meta) {
            this.meta = Optional.of(meta);
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public _FinalStage addAllTexts(List<String> texts) {
            this.texts.addAll(texts);
            return this;
        }

        @Override
        public _FinalStage addTexts(String texts) {
            this.texts.add(texts);
            return this;
        }

        @Override
        @JsonSetter(value="texts", nulls=Nulls.SKIP)
        public _FinalStage texts(List<String> texts) {
            this.texts.clear();
            this.texts.addAll(texts);
            return this;
        }

        @Override
        public _FinalStage addAllEmbeddings(List<List<Double>> embeddings) {
            this.embeddings.addAll(embeddings);
            return this;
        }

        @Override
        public _FinalStage addEmbeddings(List<Double> embeddings) {
            this.embeddings.add(embeddings);
            return this;
        }

        @Override
        @JsonSetter(value="embeddings", nulls=Nulls.SKIP)
        public _FinalStage embeddings(List<List<Double>> embeddings) {
            this.embeddings.clear();
            this.embeddings.addAll(embeddings);
            return this;
        }

        @Override
        public EmbedResponse build() {
            return new EmbedResponse(this.id, this.embeddings, this.texts, this.meta);
        }
    }

    public static interface _FinalStage {
        public EmbedResponse build();

        public _FinalStage embeddings(List<List<Double>> var1);

        public _FinalStage addEmbeddings(List<Double> var1);

        public _FinalStage addAllEmbeddings(List<List<Double>> var1);

        public _FinalStage texts(List<String> var1);

        public _FinalStage addTexts(String var1);

        public _FinalStage addAllTexts(List<String> var1);

        public _FinalStage meta(Optional<ApiMeta> var1);

        public _FinalStage meta(ApiMeta var1);
    }

    public static interface IdStage {
        public _FinalStage id(String var1);

        public Builder from(EmbedResponse var1);
    }
}

