/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.SingleGeneration;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Generation {
    private final String id;
    private final Optional<String> prompt;
    private final List<SingleGeneration> generations;
    private final Optional<ApiMeta> meta;

    private Generation(String id, Optional<String> prompt, List<SingleGeneration> generations, Optional<ApiMeta> meta) {
        this.id = id;
        this.prompt = prompt;
        this.generations = generations;
        this.meta = meta;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="prompt")
    public Optional<String> getPrompt() {
        return this.prompt;
    }

    @JsonProperty(value="generations")
    public List<SingleGeneration> getGenerations() {
        return this.generations;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Generation && this.equalTo((Generation)other);
    }

    private boolean equalTo(Generation other) {
        return this.id.equals(other.id) && this.prompt.equals(other.prompt) && this.generations.equals(other.generations) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.prompt, this.generations, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<ApiMeta> meta = Optional.empty();
        private List<SingleGeneration> generations = new ArrayList<SingleGeneration>();
        private Optional<String> prompt = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Generation other) {
            this.id(other.getId());
            this.prompt(other.getPrompt());
            this.generations(other.getGenerations());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage meta(ApiMeta meta) {
            this.meta = Optional.of(meta);
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public _FinalStage addAllGenerations(List<SingleGeneration> generations) {
            this.generations.addAll(generations);
            return this;
        }

        @Override
        public _FinalStage addGenerations(SingleGeneration generations) {
            this.generations.add(generations);
            return this;
        }

        @Override
        @JsonSetter(value="generations", nulls=Nulls.SKIP)
        public _FinalStage generations(List<SingleGeneration> generations) {
            this.generations.clear();
            this.generations.addAll(generations);
            return this;
        }

        @Override
        public _FinalStage prompt(String prompt) {
            this.prompt = Optional.of(prompt);
            return this;
        }

        @Override
        @JsonSetter(value="prompt", nulls=Nulls.SKIP)
        public _FinalStage prompt(Optional<String> prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public Generation build() {
            return new Generation(this.id, this.prompt, this.generations, this.meta);
        }
    }

    public static interface _FinalStage {
        public Generation build();

        public _FinalStage prompt(Optional<String> var1);

        public _FinalStage prompt(String var1);

        public _FinalStage generations(List<SingleGeneration> var1);

        public _FinalStage addGenerations(SingleGeneration var1);

        public _FinalStage addAllGenerations(List<SingleGeneration> var1);

        public _FinalStage meta(Optional<ApiMeta> var1);

        public _FinalStage meta(ApiMeta var1);
    }

    public static interface IdStage {
        public _FinalStage id(String var1);

        public Builder from(Generation var1);
    }
}

