/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.FinishReason;
import com.cohere.api.types.GenerationFinalResponseResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GenerationFinalResponse {
    private final boolean isFinished;
    private final Optional<FinishReason> finishReason;
    private final GenerationFinalResponseResponse response;

    private GenerationFinalResponse(boolean isFinished, Optional<FinishReason> finishReason, GenerationFinalResponseResponse response) {
        this.isFinished = isFinished;
        this.finishReason = finishReason;
        this.response = response;
    }

    @JsonProperty(value="is_finished")
    public boolean getIsFinished() {
        return this.isFinished;
    }

    @JsonProperty(value="finish_reason")
    public Optional<FinishReason> getFinishReason() {
        return this.finishReason;
    }

    @JsonProperty(value="response")
    public GenerationFinalResponseResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GenerationFinalResponse && this.equalTo((GenerationFinalResponse)other);
    }

    private boolean equalTo(GenerationFinalResponse other) {
        return this.isFinished == other.isFinished && this.finishReason.equals(other.finishReason) && this.response.equals(other.response);
    }

    public int hashCode() {
        return Objects.hash(this.isFinished, this.finishReason, this.response);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IsFinishedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IsFinishedStage,
    ResponseStage,
    _FinalStage {
        private boolean isFinished;
        private GenerationFinalResponseResponse response;
        private Optional<FinishReason> finishReason = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GenerationFinalResponse other) {
            this.isFinished(other.getIsFinished());
            this.finishReason(other.getFinishReason());
            this.response(other.getResponse());
            return this;
        }

        @Override
        @JsonSetter(value="is_finished")
        public ResponseStage isFinished(boolean isFinished) {
            this.isFinished = isFinished;
            return this;
        }

        @Override
        @JsonSetter(value="response")
        public _FinalStage response(GenerationFinalResponseResponse response) {
            this.response = response;
            return this;
        }

        @Override
        public _FinalStage finishReason(FinishReason finishReason) {
            this.finishReason = Optional.of(finishReason);
            return this;
        }

        @Override
        @JsonSetter(value="finish_reason", nulls=Nulls.SKIP)
        public _FinalStage finishReason(Optional<FinishReason> finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        @Override
        public GenerationFinalResponse build() {
            return new GenerationFinalResponse(this.isFinished, this.finishReason, this.response);
        }
    }

    public static interface _FinalStage {
        public GenerationFinalResponse build();

        public _FinalStage finishReason(Optional<FinishReason> var1);

        public _FinalStage finishReason(FinishReason var1);
    }

    public static interface ResponseStage {
        public _FinalStage response(GenerationFinalResponseResponse var1);
    }

    public static interface IsFinishedStage {
        public ResponseStage isFinished(boolean var1);

        public Builder from(GenerationFinalResponse var1);
    }
}

