/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.SingleGenerationInStream;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GenerationFinalResponseResponse {
    private final String id;
    private final Optional<SingleGenerationInStream> generations;

    private GenerationFinalResponseResponse(String id, Optional<SingleGenerationInStream> generations) {
        this.id = id;
        this.generations = generations;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="generations")
    public Optional<SingleGenerationInStream> getGenerations() {
        return this.generations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GenerationFinalResponseResponse && this.equalTo((GenerationFinalResponseResponse)other);
    }

    private boolean equalTo(GenerationFinalResponseResponse other) {
        return this.id.equals(other.id) && this.generations.equals(other.generations);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.generations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<SingleGenerationInStream> generations = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GenerationFinalResponseResponse other) {
            this.id(other.getId());
            this.generations(other.getGenerations());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage generations(SingleGenerationInStream generations) {
            this.generations = Optional.of(generations);
            return this;
        }

        @Override
        @JsonSetter(value="generations", nulls=Nulls.SKIP)
        public _FinalStage generations(Optional<SingleGenerationInStream> generations) {
            this.generations = generations;
            return this;
        }

        @Override
        public GenerationFinalResponseResponse build() {
            return new GenerationFinalResponseResponse(this.id, this.generations);
        }
    }

    public static interface _FinalStage {
        public GenerationFinalResponseResponse build();

        public _FinalStage generations(Optional<SingleGenerationInStream> var1);

        public _FinalStage generations(SingleGenerationInStream var1);
    }

    public static interface IdStage {
        public _FinalStage id(String var1);

        public Builder from(GenerationFinalResponseResponse var1);
    }
}

