/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatCitation;
import com.cohere.api.types.ChatDocument;
import com.cohere.api.types.ChatSearchQuery;
import com.cohere.api.types.ChatSearchResult;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class NonStreamedChatResponse {
    private final String text;
    private final String generationId;
    private final Optional<List<ChatCitation>> citations;
    private final Optional<List<ChatDocument>> documents;
    private final Optional<List<ChatSearchQuery>> searchQueries;
    private final Optional<List<ChatSearchResult>> searchResults;

    private NonStreamedChatResponse(String text, String generationId, Optional<List<ChatCitation>> citations, Optional<List<ChatDocument>> documents, Optional<List<ChatSearchQuery>> searchQueries, Optional<List<ChatSearchResult>> searchResults) {
        this.text = text;
        this.generationId = generationId;
        this.citations = citations;
        this.documents = documents;
        this.searchQueries = searchQueries;
        this.searchResults = searchResults;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="generation_id")
    public String getGenerationId() {
        return this.generationId;
    }

    @JsonProperty(value="citations")
    public Optional<List<ChatCitation>> getCitations() {
        return this.citations;
    }

    @JsonProperty(value="documents")
    public Optional<List<ChatDocument>> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="search_queries")
    public Optional<List<ChatSearchQuery>> getSearchQueries() {
        return this.searchQueries;
    }

    @JsonProperty(value="search_results")
    public Optional<List<ChatSearchResult>> getSearchResults() {
        return this.searchResults;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NonStreamedChatResponse && this.equalTo((NonStreamedChatResponse)other);
    }

    private boolean equalTo(NonStreamedChatResponse other) {
        return this.text.equals(other.text) && this.generationId.equals(other.generationId) && this.citations.equals(other.citations) && this.documents.equals(other.documents) && this.searchQueries.equals(other.searchQueries) && this.searchResults.equals(other.searchResults);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.generationId, this.citations, this.documents, this.searchQueries, this.searchResults);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    GenerationIdStage,
    _FinalStage {
        private String text;
        private String generationId;
        private Optional<List<ChatSearchResult>> searchResults = Optional.empty();
        private Optional<List<ChatSearchQuery>> searchQueries = Optional.empty();
        private Optional<List<ChatDocument>> documents = Optional.empty();
        private Optional<List<ChatCitation>> citations = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(NonStreamedChatResponse other) {
            this.text(other.getText());
            this.generationId(other.getGenerationId());
            this.citations(other.getCitations());
            this.documents(other.getDocuments());
            this.searchQueries(other.getSearchQueries());
            this.searchResults(other.getSearchResults());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public GenerationIdStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="generation_id")
        public _FinalStage generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        @Override
        public _FinalStage searchResults(List<ChatSearchResult> searchResults) {
            this.searchResults = Optional.of(searchResults);
            return this;
        }

        @Override
        @JsonSetter(value="search_results", nulls=Nulls.SKIP)
        public _FinalStage searchResults(Optional<List<ChatSearchResult>> searchResults) {
            this.searchResults = searchResults;
            return this;
        }

        @Override
        public _FinalStage searchQueries(List<ChatSearchQuery> searchQueries) {
            this.searchQueries = Optional.of(searchQueries);
            return this;
        }

        @Override
        @JsonSetter(value="search_queries", nulls=Nulls.SKIP)
        public _FinalStage searchQueries(Optional<List<ChatSearchQuery>> searchQueries) {
            this.searchQueries = searchQueries;
            return this;
        }

        @Override
        public _FinalStage documents(List<ChatDocument> documents) {
            this.documents = Optional.of(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(Optional<List<ChatDocument>> documents) {
            this.documents = documents;
            return this;
        }

        @Override
        public _FinalStage citations(List<ChatCitation> citations) {
            this.citations = Optional.of(citations);
            return this;
        }

        @Override
        @JsonSetter(value="citations", nulls=Nulls.SKIP)
        public _FinalStage citations(Optional<List<ChatCitation>> citations) {
            this.citations = citations;
            return this;
        }

        @Override
        public NonStreamedChatResponse build() {
            return new NonStreamedChatResponse(this.text, this.generationId, this.citations, this.documents, this.searchQueries, this.searchResults);
        }
    }

    public static interface _FinalStage {
        public NonStreamedChatResponse build();

        public _FinalStage citations(Optional<List<ChatCitation>> var1);

        public _FinalStage citations(List<ChatCitation> var1);

        public _FinalStage documents(Optional<List<ChatDocument>> var1);

        public _FinalStage documents(List<ChatDocument> var1);

        public _FinalStage searchQueries(Optional<List<ChatSearchQuery>> var1);

        public _FinalStage searchQueries(List<ChatSearchQuery> var1);

        public _FinalStage searchResults(Optional<List<ChatSearchResult>> var1);

        public _FinalStage searchResults(List<ChatSearchResult> var1);
    }

    public static interface GenerationIdStage {
        public _FinalStage generationId(String var1);
    }

    public static interface TextStage {
        public GenerationIdStage text(String var1);

        public Builder from(NonStreamedChatResponse var1);
    }
}

