/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.RerankResponseResultsItemDocument;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RerankResponseResultsItem {
    private final Optional<RerankResponseResultsItemDocument> document;
    private final int index;
    private final double relevanceScore;

    private RerankResponseResultsItem(Optional<RerankResponseResultsItemDocument> document, int index, double relevanceScore) {
        this.document = document;
        this.index = index;
        this.relevanceScore = relevanceScore;
    }

    @JsonProperty(value="document")
    public Optional<RerankResponseResultsItemDocument> getDocument() {
        return this.document;
    }

    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    @JsonProperty(value="relevance_score")
    public double getRelevanceScore() {
        return this.relevanceScore;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RerankResponseResultsItem && this.equalTo((RerankResponseResultsItem)other);
    }

    private boolean equalTo(RerankResponseResultsItem other) {
        return this.document.equals(other.document) && this.index == other.index && this.relevanceScore == other.relevanceScore;
    }

    public int hashCode() {
        return Objects.hash(this.document, this.index, this.relevanceScore);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IndexStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IndexStage,
    RelevanceScoreStage,
    _FinalStage {
        private int index;
        private double relevanceScore;
        private Optional<RerankResponseResultsItemDocument> document = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(RerankResponseResultsItem other) {
            this.document(other.getDocument());
            this.index(other.getIndex());
            this.relevanceScore(other.getRelevanceScore());
            return this;
        }

        @Override
        @JsonSetter(value="index")
        public RelevanceScoreStage index(int index) {
            this.index = index;
            return this;
        }

        @Override
        @JsonSetter(value="relevance_score")
        public _FinalStage relevanceScore(double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        @Override
        public _FinalStage document(RerankResponseResultsItemDocument document) {
            this.document = Optional.of(document);
            return this;
        }

        @Override
        @JsonSetter(value="document", nulls=Nulls.SKIP)
        public _FinalStage document(Optional<RerankResponseResultsItemDocument> document) {
            this.document = document;
            return this;
        }

        @Override
        public RerankResponseResultsItem build() {
            return new RerankResponseResultsItem(this.document, this.index, this.relevanceScore);
        }
    }

    public static interface _FinalStage {
        public RerankResponseResultsItem build();

        public _FinalStage document(Optional<RerankResponseResultsItemDocument> var1);

        public _FinalStage document(RerankResponseResultsItemDocument var1);
    }

    public static interface RelevanceScoreStage {
        public _FinalStage relevanceScore(double var1);
    }

    public static interface IndexStage {
        public RelevanceScoreStage index(int var1);

        public Builder from(RerankResponseResultsItem var1);
    }
}

