/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.FinishReason;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SingleGenerationInStream {
    private final String id;
    private final String text;
    private final Optional<Integer> index;
    private final FinishReason finishReason;

    private SingleGenerationInStream(String id, String text, Optional<Integer> index, FinishReason finishReason) {
        this.id = id;
        this.text = text;
        this.index = index;
        this.finishReason = finishReason;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return this.index;
    }

    @JsonProperty(value="finish_reason")
    public FinishReason getFinishReason() {
        return this.finishReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SingleGenerationInStream && this.equalTo((SingleGenerationInStream)other);
    }

    private boolean equalTo(SingleGenerationInStream other) {
        return this.id.equals(other.id) && this.text.equals(other.text) && this.index.equals(other.index) && this.finishReason.equals((Object)other.finishReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.text, this.index, this.finishReason});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TextStage,
    FinishReasonStage,
    _FinalStage {
        private String id;
        private String text;
        private FinishReason finishReason;
        private Optional<Integer> index = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(SingleGenerationInStream other) {
            this.id(other.getId());
            this.text(other.getText());
            this.index(other.getIndex());
            this.finishReason(other.getFinishReason());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TextStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public FinishReasonStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="finish_reason")
        public _FinalStage finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        @Override
        public _FinalStage index(Integer index) {
            this.index = Optional.of(index);
            return this;
        }

        @Override
        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public _FinalStage index(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        @Override
        public SingleGenerationInStream build() {
            return new SingleGenerationInStream(this.id, this.text, this.index, this.finishReason);
        }
    }

    public static interface _FinalStage {
        public SingleGenerationInStream build();

        public _FinalStage index(Optional<Integer> var1);

        public _FinalStage index(Integer var1);
    }

    public static interface FinishReasonStage {
        public _FinalStage finishReason(FinishReason var1);
    }

    public static interface TextStage {
        public FinishReasonStage text(String var1);
    }

    public static interface IdStage {
        public TextStage id(String var1);

        public Builder from(SingleGenerationInStream var1);
    }
}

