/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.GenerationFinalResponse;
import com.cohere.api.types.GenerationStream;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class StreamedGenerationItem {
    private final Object value;
    private final int type;

    private StreamedGenerationItem(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((GenerationStream)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((GenerationFinalResponse)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StreamedGenerationItem && this.equalTo((StreamedGenerationItem)other);
    }

    private boolean equalTo(StreamedGenerationItem other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static StreamedGenerationItem of(GenerationStream value) {
        return new StreamedGenerationItem(value, 0);
    }

    public static StreamedGenerationItem of(GenerationFinalResponse value) {
        return new StreamedGenerationItem(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<StreamedGenerationItem> {
        Deserializer() {
            super(StreamedGenerationItem.class);
        }

        public StreamedGenerationItem deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return StreamedGenerationItem.of((GenerationStream)ObjectMappers.JSON_MAPPER.convertValue(value, GenerationStream.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return StreamedGenerationItem.of((GenerationFinalResponse)ObjectMappers.JSON_MAPPER.convertValue(value, GenerationFinalResponse.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(GenerationStream var1);

        public T visit(GenerationFinalResponse var1);
    }
}

